# TODO:
#  - generate old style command definitions for NRPE?

%define nagios_plugdir %_libexecdir/nagios/plugins
%define plugins_cmddir %_sysconfdir/nagios/commands
%define nagios_usr nagios
%define nagios_grp nagios

Name: nagios-plugins
Version: 2.4.12
Release: alt1

Summary: Host/service/network monitoring plug-ins for Nagios(R)
Summary(ru_RU.UTF-8): Модули мониторинга (plug-ins) хостов/сервисов/сети для Nagios(R)

License: GPL-3.0
Group: Monitoring
URL: http://nagiosplug.sourceforge.net
Vcs: https://github.com/nagios-plugins/nagios-plugins.git

Packager: Dmitry Lebkov <dlebkov@altlinux.ru>

Source0: %name-%version.tar
Source1: notify_via_jabber
Source2: nagios-plugins-README.ALT.UTF-8

# Commands definitions for Nagios
Source10: nagios-plugins.cfg
Source11: nagios-plugins-local.cfg
Source12: nagios-plugins-network.cfg
Source13: nagios-plugins-ldap.cfg
Source14: nagios-plugins-mysql.cfg
Source15: nagios-plugins-pgsql.cfg
Source16: nagios-plugins-radius.cfg
Source17: nagios-plugins-samba.cfg
Source18: nagios-plugins-perl.cfg
Source19: nagios-plugins-snmp.cfg
Source20: nagios-plugins-extra.cfg

Patch1: %name-%version-alt-makefile.patch
Patch3: %name-1.4.12-alt-pgsql.patch
Patch102: nagios-plugins-0002-Remove-assignment-of-not-parsed-to-jitter.patch

%define _perl_lib_path %nagios_plugdir

Requires: nagios-plugins-common = %version-%release
Requires: iputils procps

# Automatically added by buildreq on Tue Aug 12 2008
BuildRequires: libMySQL-devel libldap-devel libradiusclient-ng-devel libpq-devel libssl-devel postgresql-devel zlib-devel perl-Math-BigInt perl-Net-SNMP
BuildRequires: perl(Crypt/X509.pm)
BuildRequires: perl(Date/Parse.pm)
BuildRequires: perl(LWP/Simple.pm)
BuildRequires: perl(Text/Glob.pm)

# checked in configure checking
BuildRequires: iputils procps fping qstat rpcbind bind-utils net-snmp-clients openssh-clients glibc-utils samba-client
BuildRequires: sendmail-common MTA

# for correct ps detection
BuildRequires: /proc

%description
Nagios is a program that will monitor hosts and services on your
network, and to email or page you when a problem arises or is
resolved. Nagios runs on a unix server as a background or daemon
process, intermittently running checks on various services that you
specify. The actual service checks are performed by separate "plugin"
programs which return the status of the checks to Nagios.

This package contains the basic plugins necessary for use with the
Nagios package.  This package should install cleanly on almost any
RPM-based system.

%package common
Summary: Common files for Nagios(R) plug-ins
Group: Monitoring
Requires(pre): nagios-daemon

%description common
Common files for Nagios(R) plugi-ins.


%package local
Summary: Nagios(R) plug-ins for checking local services and resources
Group: Monitoring
Requires: nagios-plugins-common = %version-%release
Requires: procps

%description local
Nagios(R) plugi-ins for checking local services and resources.


%package network
Summary: Nagios(R) plug-ins for checking remote hosts and services
Group: Monitoring
Requires: nagios-plugins-common = %version-%release
Requires: openssh-clients bind-utils fping iputils ntpdate

%description network
Nagios(R) plugi-ins for checking remote hosts and services.


%package ldap
Summary: Nagios(R) plug-in for checking LDAP-server
Group: Monitoring
Requires: nagios-plugins-common = %version-%release

%description ldap
Nagios(R) plugi-in for checking LDAP server.


%package mysql
Summary: Nagios(R) plug-in for checking MySQL server
Group: Monitoring
Requires: nagios-plugins-common = %version-%release

%description mysql
Nagios(R) plugi-in for checking MySQL server.


%package pgsql
Summary: Nagios(R) plug-in for checking PostgreSQL server
Group: Monitoring
Requires: nagios-plugins-common = %version-%release

%description pgsql
Nagios(R) plugi-in for checking PostgreSQL server.


%package radius
Summary: Nagios(R) plug-in for checking RADIUS server
Group: Monitoring
Requires: nagios-plugins-common = %version-%release

%description radius
Nagios(R) plugi-in for checking RADIUS server.


%package perl
Summary: Nagios(R) plug-ins written in Perl language.
Group: Monitoring
Requires: nagios-plugins-common = %version-%release
Requires: sendmail-common glibc-utils

%description perl
Variaous Nagios(R) plugi-ins, writen in Perl language.

%package samba
Summary: Nagios(R) samba plug-in written in Perl language.
Group: Monitoring
Requires: nagios-plugins-common = %version-%release
Requires: samba-client

%description samba
Samba Nagios(R) plug-in, writen in Perl language.

%package snmp
Summary: Nagios(R) plug-ins for SNMP checks
Group: Monitoring
Requires: nagios-plugins-common = %version-%release
Requires: net-snmp-clients

%description snmp
Nagios(R) plug-ins for SNMP checks

%package extra
Summary: Nagios(R) plug-ins which depend on the presence of other software
Group: Monitoring
Requires: nagios-plugins-common = %version-%release
Requires: qstat lm_sensors

%description extra
This package contains plugins which use additional software libraries that
are not installed on all systems.

%prep
%setup -n %name-%version
%patch1 -b .p1
%patch3 -p1 -b .p3
%patch102 -p1 -b .p102

# fix ps checking
%__subst "s|\[UCOMAND\]+|COMMAND|g" configure*
# https://bbs.archlinux.org/viewtopic.php?id=145693
#sed -i -e '/gets is a security/d' gl/stdio.in.h

%build
%autoreconf
# configure searches some root only commands
PATH=$PATH:/usr/sbin
export ac_cv_path_PATH_TO_FPING=%_sbindir/fping
%configure \
	--libexecdir=%nagios_plugdir \
	--with-cgiurl=/nagios/cgi-bin \
	--with-gnutls=/usr \
	--with-pgsql=/usr \
	--with-mysql=/usr \
	--with-openssl=/usr \
	--with-libiconv-prefix=/usr \
	--without-included-gettext \
	--with-libintl-prefix=/usr \
	--without-ipv6 \
	--with-ping-command='/bin/ping -n -U -w %%d -c %%d %%s' \
	--with-fping-command='%_sbindir/fping' \
	--with-proc-loadavg='/proc/loadavg' \
	--with-proc-meminfo='/proc/meminfo' \
	--disable-rpath \
	#

%make_build
%make THANKS

%install
#chmod 0644 command.cfg
%makeinstall_std AM_INSTALL_PROGRAM_FLAGS= MKDIR_P='mkdir -p'

# install Nagios commands deinitions
mkdir -p %buildroot/%plugins_cmddir
install -m 644 %SOURCE10 %buildroot/%plugins_cmddir/
install -m 644 %SOURCE11 %buildroot/%plugins_cmddir/
install -m 644 %SOURCE12 %buildroot/%plugins_cmddir/
install -m 644 %SOURCE13 %buildroot/%plugins_cmddir/
install -m 644 %SOURCE14 %buildroot/%plugins_cmddir/
install -m 644 %SOURCE15 %buildroot/%plugins_cmddir/
install -m 644 %SOURCE16 %buildroot/%plugins_cmddir/
install -m 644 %SOURCE17 %buildroot/%plugins_cmddir/
install -m 644 %SOURCE18 %buildroot/%plugins_cmddir/
install -m 644 %SOURCE19 %buildroot/%plugins_cmddir/
install -m 644 %SOURCE20 %buildroot/%plugins_cmddir/


# install contrib add-ons
#mkdir -p %buildroot%_docdir/%name-extra-%version/contrib
#for i in `ls contrib/tarballs/*.gz`; do
# install -m 644 $i %buildroot%_docdir/%name-extra-%version/contrib
#done

#pushd contrib
# tar -cvzf %buildroot%_docdir/%name-extra-%version/contrib/contrib-misc.tar.gz \
#  `find ./ -maxdepth 1 -type f -print0 | xargs -r0`
#popd

#install -m 644 contrib/README.TXT %buildroot%_docdir/%name-extra-%version/contrib
#install -m 644 %SOURCE1 %buildroot%_docdir/%name-extra-%version/contrib

mkdir -p %buildroot%_docdir/%name-%version
install -pm644 ACKNOWLEDGEMENTS AUTHORS FAQ LEGAL NEWS README REQUIREMENTS SUPPORT THANKS \
	%buildroot%_docdir/%name-%version/
install -pm644 %SOURCE2 %buildroot%_docdir/%name-%version/README.ALT.UTF-8

%find_lang %name

%files common -f %name.lang
%dir %nagios_plugdir
#common files
%nagios_plugdir/negate
%nagios_plugdir/utils.sh
%nagios_plugdir/utils.pm
%nagios_plugdir/urlize

%files
%plugins_cmddir/nagios-plugins.cfg
%nagios_plugdir/check_ping
%nagios_plugdir/check_nagios
%nagios_plugdir/check_load
%nagios_plugdir/check_uptime
%nagios_plugdir/check_procs
%nagios_plugdir/check_ssl_validity
%dir %_docdir/%name-%version
%_docdir/%name-%version/*

%files local
%plugins_cmddir/nagios-plugins-local.cfg
%nagios_plugdir/check_apt
%nagios_plugdir/check_disk
%nagios_plugdir/check_ide_smart
%nagios_plugdir/check_dummy
%nagios_plugdir/check_file_age
%nagios_plugdir/check_log
%nagios_plugdir/check_mrtg
%nagios_plugdir/check_mrtgtraf
%nagios_plugdir/check_swap
%nagios_plugdir/check_users
%nagios_plugdir/remove_perfdata

%files network
%plugins_cmddir/nagios-plugins-network.cfg
%nagios_plugdir/check_by_ssh
%nagios_plugdir/check_clamd
%nagios_plugdir/check_cluster
%nagios_plugdir/check_dig
%nagios_plugdir/check_dns
%nagios_plugdir/check_dhcp
%nagios_plugdir/check_fping
%nagios_plugdir/check_ftp
%nagios_plugdir/check_http
%nagios_plugdir/check_icmp
%nagios_plugdir/check_imap
%nagios_plugdir/check_jabber
%nagios_plugdir/check_nntp
%nagios_plugdir/check_nntps
%nagios_plugdir/check_nt
%nagios_plugdir/check_ntp
%nagios_plugdir/check_ntp_peer
%nagios_plugdir/check_ntp_time
%nagios_plugdir/check_nwstat
%nagios_plugdir/check_overcr
%nagios_plugdir/check_pop
%nagios_plugdir/check_real
%nagios_plugdir/check_simap
%nagios_plugdir/check_smtp
%nagios_plugdir/check_ssmtp
%nagios_plugdir/check_spop
%nagios_plugdir/check_ssh
%nagios_plugdir/check_tcp
%nagios_plugdir/check_time
%nagios_plugdir/check_udp
%nagios_plugdir/check_ups

%files ldap
%plugins_cmddir/nagios-plugins-ldap.cfg
%nagios_plugdir/check_ldap
%nagios_plugdir/check_ldaps

%files mysql
%plugins_cmddir/nagios-plugins-mysql.cfg
%nagios_plugdir/check_mysql
%nagios_plugdir/check_mysql_query

%files pgsql
%plugins_cmddir/nagios-plugins-pgsql.cfg
%nagios_plugdir/check_pgsql

%files radius
%plugins_cmddir/nagios-plugins-radius.cfg
%nagios_plugdir/check_radius

%files samba
%plugins_cmddir/nagios-plugins-samba.cfg
%nagios_plugdir/check_disk_smb

%files perl
%plugins_cmddir/nagios-plugins-perl.cfg
%nagios_plugdir/check_ifoperstatus
%nagios_plugdir/check_ifstatus
%nagios_plugdir/check_ircd
%nagios_plugdir/check_mailq
%nagios_plugdir/check_rpc

%files snmp
%plugins_cmddir/nagios-plugins-snmp.cfg
%nagios_plugdir/check_breeze
%nagios_plugdir/check_hpjd
%nagios_plugdir/check_snmp
%nagios_plugdir/check_wave

%files extra
%plugins_cmddir/nagios-plugins-extra.cfg
%nagios_plugdir/check_flexlm
%nagios_plugdir/check_game
%nagios_plugdir/check_oracle
%nagios_plugdir/check_sensors
#dir %_docdir/%name-extra-%version
#_docdir/%name-extra-%version/*

%changelog
