# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%set_verify_elf_method unresolved=relaxed

%define api_ver 0
%define sover 0

Name: muffin
Version: 6.4.1
Release: alt1

Summary: Window and compositing manager based on Clutter
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME

Url: https://github.com/linuxmint/muffin

Source: %name-%version.tar
Patch: %name-%version-%release.patch

# since 4.0 muffin forks Cogl and Clutter libraries into own private libraries
%filter_from_provides /typelib[(]Cally[)]/d
%filter_from_provides /typelib[(]Clutter[)]/d
%filter_from_provides /typelib[(]ClutterX11[)]/d
%filter_from_provides /typelib[(]Cogl[)]/d
%filter_from_provides /typelib[(]CoglPango[)]/d
%filter_from_requires /typelib[(]Cally[)]/d
%filter_from_requires /typelib[(]Clutter[)]/d
%filter_from_requires /typelib[(]ClutterX11[)]/d
%filter_from_requires /typelib[(]Cogl[)]/d
%filter_from_requires /typelib[(]CoglPango[)]/d

%filter_from_provides /gir[(]Cally[)]/d
%filter_from_provides /gir[(]Clutter[)]/d
%filter_from_provides /gir[(]ClutterX11[)]/d
%filter_from_provides /gir[(]Cogl[)]/d
%filter_from_provides /gir[(]CoglPango[)]/d
%filter_from_requires /gir[(]Cally[)]/d
%filter_from_requires /gir[(]Clutter[)]/d
%filter_from_requires /gir[(]ClutterX11[)]/d
%filter_from_requires /gir[(]Cogl[)]/d
%filter_from_requires /gir[(]CoglPango[)]/d

# There is already registered upstream issue https://github.com/linuxmint/muffin/issues/199
# But untill it will be fixed by Cinnamon devs we handle it manually.
%filter_from_provides /typelib(Meta)/d
%filter_from_provides /gir(Meta)/d

Requires: lib%name = %version-%release
Requires: zenity

BuildPreReq: rpm-build-gir >= 0.7.1-alt6
BuildPreReq: libgtk+3-devel >= 3.3.3
BuildPreReq: meson
BuildRequires: libcanberra-gtk3-devel libstartup-notification-devel
BuildRequires: libXrandr-devel libXcursor-devel libXcomposite-devel
BuildRequires: libXinerama-devel libXext-devel libSM-devel
BuildRequires: zenity
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: libcinnamon-desktop-devel libcinnamon-desktop-gir-devel
BuildRequires: libxkbcommon-x11-devel libxkbfile-devel xkeyboard-config-devel
BuildRequires: libXi-devel libXdamage-devel
BuildRequires: libjson-glib-devel libjson-glib-gir-devel
BuildRequires: libgbm-devel
BuildRequires: libwayland-server-devel libwayland-egl-devel
BuildRequires: libdrm-devel libGL-devel
BuildRequires: libxcb-devel libXtst-devel
BuildRequires: libgudev-devel libinput-devel
BuildRequires: libEGL-devel
BuildRequires: libgraphene-devel libgraphene-gir-devel libfribidi-devel libdbus-devel pipewire-libs-devel
BuildRequires: libwacom-devel
BuildRequires: wayland-protocols
BuildRequires: libsystemd-devel
BuildRequires: xorg-xwayland
BuildRequires: cvt

%description
Muffin is a window and compositing manager that displays and manages
your desktop via OpenGL. Muffin combines a sophisticated display engine
using the Clutter toolkit with solid window-management logic inherited
from the Metacity window manager.

While Muffin can be used stand-alone, it is primarily intended to be
used as the display core of a larger system such as Cinnamon.
For this reason, Muffin is very extensible via plugins, which
are used both to add fancy visual effects and to rework the window
management behaviors to meet the needs of the environment.

%package -n lib%name
Summary: Shared libraries for %name
Group: System/Libraries
# manual dependencies
Requires: typelib(Gtk) = 3.0

%description -n lib%name
Shared libraries for Muffin and its plugins.

%package -n lib%name-devel
Summary: Development package for %name
Group: Development/C
Requires: lib%name = %version-%release
# manual dependencies
Requires: gir(Gtk) = 3.0

%description -n lib%name-devel
Header files and libraries for developing Muffin plugins.

%package -n lib%name-devel-doc
Summary: Development doc package for %name
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
Development docs package for Muffin.

%package -n lib%name-gir
Summary: GObject introspection data for the Muffin library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Muffin library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Muffin library
Group: System/Libraries
Requires: lib%name-devel = %version-%release lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Muffin library

%set_typelibdir %_libdir/%name
%set_girdir %_libdir/%name

%package -n %name-cinnamon
Summary: Cinnamon-specific parts of Mutter
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: %name = %EVR

%description -n %name-cinnamon
This package contains everything necessary to use Mutter in Cinnamon desktop
environment.

%prep
%setup -n %name-%version

%build
%meson
%meson_build


%install
%meson_install

%find_lang %name


ln -sf %name/lib%name-clutter-%api_ver.so.%sover \
%buildroot%_libdir/lib%name-clutter-%api_ver.so.%sover

ln -sf %name/lib%name-cogl-%api_ver.so.%sover \
%buildroot%_libdir/lib%name-cogl-%api_ver.so.%sover

%files -f %name.lang
%_man1dir/muffin.1*
%_bindir/muffin
%_libexecdir/muffin-restart-helper
%_desktopdir/*.desktop
%doc README.md

%files -n lib%name
%_libdir/lib*.so.*
%_libdir/%name/lib*.so.*
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/*.so
%dir %_libdir/%name

%files -n lib%name-devel
%_includedir/*
%_libdir/lib*.so
%_libdir/%name/*.so
%_pkgconfigdir/*

%files -n lib%name-gir
%_libdir/%name/*.typelib

%files -n lib%name-gir-devel
%_libdir/%name/*.gir

%files -n %name-cinnamon
%_datadir/glib-2.0/schemas/org.cinnamon.*.xml

%changelog
