%def_without qt5

Name: mpz
Version: 1.1.1
Release: alt1

Summary: Music player for the large local collections

License: GPL-3.0-or-later
Group: Sound
Url: https://github.com/olegantonyan/mpz

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/olegantonyan/mpz/archive/%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: rpm-build-cmake
%if_with qt5
BuildRequires: qt5-base-devel qt5-multimedia-devel qt5-x11extras-devel
%else
BuildRequires: pkgconfig(Qt6Core)
BuildRequires: pkgconfig(Qt6Widgets)
BuildRequires: pkgconfig(Qt6Multimedia)
BuildRequires: pkgconfig(Qt6Network)
BuildRequires: pkgconfig(Qt6Concurrent)
BuildRequires: pkgconfig(Qt6DBus)
%endif

BuildRequires: pkgconfig(yaml-cpp)
BuildRequires: pkgconfig(taglib)

%description
Music player for big local collections. Treats your folders with music as a library.
Features 3-column UI: directory tree viewer, playlists list and tracks from current playlist.
Similar to "album list" in Foobar2000.

%prep
%setup
rm -rv 3rdparty/{yaml-cpp,taglib,utfcpp}-*

%build
%cmake \
    -DUSE_SYSTEM_YAMLCPP=TRUE \
    -DUSE_SYSTEM_TAGLIB=TRUE \
    %nil
%cmake_build

%install
%cmake_install
rm -v %buildroot/usr/share/licenses/mpz/license.txt

%files
%doc license.txt
%_bindir/%name
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*x*/apps/%name.png

%changelog
