Name: morse
Summary: Morse Classic morse trainer program
Version: 2.6
Release: alt1
License: BSD
Group: Communications
Url: http://catb.org/~esr/morse/
Vcs: https://gitlab.com/esr/morse-classic.git
Source0: %name-%version.tar
Patch01: 01-morsexml.patch
Patch02: 02-hardening.patch
Patch03: 03-fix-pa_simple_write-with-mono-output.patch
Patch04: 04-fix_ftbfs.patch
Patch05: 05-fix_-X_handling.patch
Patch06: 06-cross.patch
Patch07: 07-gcc-14.patch

%define Backends X11 OSS Linux PA ALSA

# Automatically added by buildreq on Tue Jun 28 2011
# optimized out: alternatives docbook-dtds docbook-style-xsl libgpg-error pkg-config xml-common xml-utils xorg-xproto-devel xsltproc
BuildRequires: libX11-devel libalsa-devel libpulseaudio-devel xmlto

BuildRequires: xsltproc docbook-dtds docbook-style-xsl

%description
Morse Classic is a Morse-code training program for aspiring radio hams.  It
can generate random tests or simulated QSOs resembling those used in
the ARRL test (a QSO generator is included).  There are a plethora of
options to vary the training method.  In one of the simpler modes,
this program will take text from standard input and render it as
Morse-code beeps.

%prep
%setup
%autopatch -p1

%build
rm -f morse.1
make DEVICE=ALSA QSO morse.1
for DEVICE in %Backends; do
make -C morse.d DEVICE=$DEVICE morse
done

%install
install -D QSO %buildroot%_bindir/QSO
install morse.d/%name[^.]* %buildroot%_bindir/
ln -s morseALSA %buildroot%_bindir/morse
install -D %name.1 %buildroot%_man1dir/%name.1

%files
%doc README HISTORY

%_man1dir/%name.1*
%_bindir/%{name}*
%_bindir/QSO

%changelog
