%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Summary: A collection of UNIX tools
Name: moreutils
Version: 0.70
Release: alt1
License: GPL-2.0-or-later
Group: File tools
Url: http://joeyh.name/code/moreutils/
Vcs: https://git.joeyh.name/index.cgi/moreutils.git

Source0: %name-%version.tar
BuildRequires: docbook2X
BuildRequires: docbook-dtds
BuildRequires: perl-IPC-Run
BuildRequires: perl-podlators
%{?!_without_check:%{?!_disable_check:
BuildRequires: /proc
}}

%description
A collection of UNIX tools that nobody thought to write long ago, when
UNIX was young. Currently it consists of these tools:

 - chronic: runs a command quietly unless it fails
 - combine: combine the lines in two files using boolean operations
 - errno: look up errno names and descriptions
 - ifdata: get network interface info without parsing ifconfig output
 - isutf8: check if a file or standard input is utf-8
 - ifne: run a command if the standard input is not empty
 - lckdo: execute a program with a lock held (deprecated)
 - mispipe: pipe two commands, returning the exit status of the first
 - parallel: run multiple jobs at once (in %name-parallel package)
 - pee: tee standard input to pipes
 - sponge: soak up standard input and write to a file
 - ts: timestamp standard input
 - vidir: edit a directory in your text editor
 - vipe: insert a text editor into a pipe
 - zrun: automatically uncompress arguments to command

%package parallel
Summary: Run multiple jobs at once
Group: File tools
Conflicts: parallel

%description parallel
parallel runs the specified command, passing it a single one of the
specified arguments. This is repeated for each argument. Jobs may be
run in parallel. The default is to run one job per CPU.

%prep
%setup

# Adjust paths for ALT:
sed -i -e 's,"file:///.*docbookx\.dtd","/usr/share/sgml/docbook/dtd/4.4/docbookx.dtd",' *.docbook

%build
%add_optflags %(getconf LFS_CFLAGS)
%make_build DOCBOOK2XMAN=db2x_docbook2man CC=gcc CFLAGS="%optflags"

%install
%makeinstall_std
# ts's man conflicts with openssl. Tool name first so that user can type `man
# ts<tab>` and see there is another page.
mv %buildroot%_man1dir/ts.1 %buildroot%_man1dir/ts-%name.1

%check
make check

%files
%doc README is_utf8/README.md COPYING
%_bindir/*
%_man1dir/*.1*
%exclude %_bindir/parallel
%exclude %_man1dir/parallel.1*

%files parallel
%doc COPYING
%_bindir/parallel
%_man1dir/parallel.1*

%changelog
