%define _unpackaged_files_terminate_build 1

Name: mockito
Version: 5.20.0
Release: alt3

Summary: Tasty mocking framework for unit tests in Java
License: MIT
Group: Development/Java
Url: https://site.mockito.org
Vcs: https://github.com/mockito/mockito.git
BuildArch: noarch

Source0: %name-%version.tar
Patch0: %name-%version-alt-patch.patch

BuildRequires(pre): rpm-macros-gradle
BuildRequires: /proc
BuildRequires: rpm-build-java-osgi
BuildRequires: jpackage-17-compat
BuildRequires: xgradle
BuildRequires: biz-aQute-bnd-gradle-plugins
BuildRequires: junit
BuildRequires: byte-buddy
BuildRequires: byte-buddy-agent
BuildRequires: maven-plugin-bundle
BuildRequires: apiguardian
BuildRequires: assertj-core
BuildRequires: hamcrest
BuildRequires: junit5
BuildRequires: objenesis
BuildRequires: opentest4j
BuildRequires: objectweb-asm
BuildRequires: guava
BuildRequires: google-error-prone-core
BuildRequires: auto-common
BuildRequires: auto-service
Requires: mockito-core

%description
Mockito is a mocking framework that tastes really good. It lets you write
beautiful tests with clean & simple API. Mockito doesn't give you hangover
because the tests are very readable and they produce clean verification
errors.

%package core
Summary: Core classes of Mockito
Group: Development/Java
BuildArch: noarch

%description core
This package contains the core Mockito library with essential APIs and runtime
required for creating and using mocks.

%package junit-jupiter
Summary: JUnit Jupiter integration for Mockito
Group: Development/Java
BuildArch: noarch
Requires: mockito-core

%description junit-jupiter
This package provides integration helpers and extensions to use Mockito with
JUnit Jupiter. It contains the Mockito-specific JUnit 5 extension and
supporting classes that make it easy to use Mockito in JUnit Jupiter based
tests.

%package subclass
Summary: Subclass mocking support for Mockito
Group: Development/Java
BuildArch: noarch
Requires: mockito-core

%description subclass
This package provides the "subclass" mock maker for Mockito. It enables
creation of mocks using subclassing mechanisms and contains the runtime
components required for subclass based mock generation. This subpackage
provides the implementation pieces that enable creating mocks by subclassing
where proxy-based mocking is not suitable.

%package proxy
Summary: Proxy-based mocking utilities for Mockito
Group: Development/Java
BuildArch: noarch
Requires: mockito-core

%description proxy
This package provides the "proxy" mock maker for Mockito. It offers proxy based
mock implementations and includes the runtime infrastructure used to generate
mocks through dynamic proxies. Useful on platforms or configurations that
prefer proxying over subclassing.

%package errorprone
Summary: Integration between Mockito and Error Prone
Group: Development/Java
BuildArch: noarch
Requires: mockito-core

%description errorprone
This package provides integration helpers and runtime components that enable
Mockito to interoperate with Google's Error Prone static analysis tool.
It contains the Mockito-specific error-prone plugin/extension artifacts (jar
and pom) which help Error Prone perform additional compile-time checks and
enhanced diagnostics for code that uses Mockito.

%prep
%setup
%autopatch -p1

# Remove unwanted directory for RPM build(requires kotlin-dsl).
rm -rf buildSrc

# Compatibility alias
%mvn_alias org.mockito:mokito-core org.mockito:mockito-all

%build
%gradle_publish

%install
%gradle_register
%gradle_register_bom

%gradle_install

%files
%nil

%files core
%_mavenmetadatadir/mockito.xml
%_javadir/mockito/mockito-core.jar
%_mavenpomdir/mockito/mockito-core.pom
%_mavenpomdir/mockito/mockito-bom.pom
%doc --no-dereference LICENSE
%doc README.md doc/design-docs/custom-argument-matching.md

%files junit-jupiter
%_javadir/mockito/mockito-junit-jupiter.jar
%_mavenpomdir/mockito/mockito-junit-jupiter.pom

%files subclass
%_javadir/mockito/mockito-subclass.jar
%_mavenpomdir/mockito/mockito-subclass.pom

%files proxy
%_javadir/mockito/mockito-proxy.jar
%_mavenpomdir/mockito/mockito-proxy.pom

# Must be used with adding --enable-preview compiler argument because of error_prone_core.
%files errorprone
%_javadir/mockito/mockito-errorprone.jar
%_mavenpomdir/mockito/mockito-errorprone.pom

%changelog
