%filter_from_requires /\/etc\/mellanox\/mlnx-ovs.conf/d
%filter_from_requires /\/etc\/mellanox\/mlnx-sf.conf/d
%filter_from_requires /\/etc\/mellanox\/mlnx-bf.conf/d
%filter_from_requires /systemd/d
%filter_from_requires /\/bin\/systemctl/d
%filter_from_requires /\/sbin\/systemctl/d
%filter_from_requires \/sbin\/sysctl/d
%filter_from_requires \/etc\/sysconfig/d

%define _udevrulesdir /lib/udev/rules.d
%define _udevdir /lib/udev

Name: mlnx-tools
Version: 2510.0.14
Release: alt1

Summary: Mellanox userland tools and scripts

License: BSD-style or CPL-1.0 or GPL-2.0-only and GPL-2.0-or-later and MIT
Group: System/Kernel and hardware
Url: https://github.com/Mellanox/mlnx-tools
Vcs: https://github.com/Mellanox/mlnx-tools

# Source-url: https://github.com/Mellanox/mlnx-tools/releases/download/v%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: perl-devel python3-devel
Requires: python3-module-termcolor python3-module-anytree
# python3-module-mlnx includes dcbnetlink
%add_python3_req_skip dcbnetlink
Requires: python3-module-mlnx

%description
Mellanox userland tools and scripts

%package -n python3-module-mlnx
Summary: Python3 bindings for %name
Group: Development/Python3

%description -n python3-module-mlnx
The package provides python3 bindings for %name.

%prep
%setup -n %name-%version
%autopatch -p1
sed -e 's|/usr/share/mlnx-tools/python|%python3_sitelibdir/%name|g' \
    -i Makefile \
    -i python/Python/dcbnetlink.py \
    -i python/mlnx_qos
sed -e 's|/usr/bin/env python3|%__python3|;' \
    -i $(find ./python -type f -print) \
    -i tsbin/mlnx-sf \
    -i tsbin/doca-hugepages
sed -e 's|openvswitch-switch|openvswitch|g;' \
    -e 's|/usr/lib/systemd/system|%_unitdir|;' \
    -i tsbin/mlnx_bf_configure

%install
%makeinstall_std
chmod +x %buildroot%python3_sitelibdir/%name/dcbnetlink.py

%files
%doc doc/* COPYING LICENSE README.md debian/changelog
/sbin/sysctl_perf_tuning
/sbin/mlnx_bf_configure
/sbin/mlnx-sf
/sbin/doca-hugepages
/lib/udev/mlnx_bf_udev
%_sbindir/*
%_bindir/*
%_man8dir/ib2ib_setup.8*
%_man8dir/mlnxofedctl.8*

%files -n python3-module-mlnx
%python3_sitelibdir/%name/

%changelog
