%def_with l10n
%define _hardened_build 1
%global gitname celeron55
%define irrlichtmt_version 1.9.0mt13

Name: minetest
Version: 5.14.0
Release: alt1
Summary: Multiplayer infinite-world block sandbox with survival mode
License: LGPL-2.0+ and CC-BY-SA-3.0
Group: Games/Other
URL: https://www.minetest.net

# VCS (executable): https://github.com/minetest/minetest.git
# VCS (data files): https://github.com/minetest/minetest_game.git

# wget https://raw.github.com/RussianFedora/minetest/fedora/minetest.desktop
# wget https://raw.github.com/RussianFedora/minetest/fedora/minetest.service
# wget https://raw.github.com/RussianFedora/minetest/fedora/minetest.rsyslog
# wget https://raw.github.com/RussianFedora/minetest/fedora/minetest.logrotate
# wget https://raw.github.com/RussianFedora/minetest/fedora/minetest.README
Source0: luanti-%version.tar.gz
Source2: %{name}.service
Source3: %{name}.rsyslog
Source4: %{name}.logrotate
Source5: %{name}.README
Source6: %{name}_game-5.8.0.tar.gz
Source7: http://www.gnu.org/licenses/lgpl-2.1.txt
# Now using its own Minetest-specific fork of irrlicht.
#Source8:	https://github.com/minetest/irrlicht/archive/%{irrlichtmt_version}/irrlicht-%{irrlichtmt_version}.tar.gz

Patch0:   includes.patch
Patch1:   metainfo.patch

#ExcludeArch: aarch64
BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
#BuildRequires: libirrlicht-devel
BuildRequires: bzip2-devel jthread-devel libsqlite3-devel libSDL2-devel
BuildRequires: libpng-devel libjpeg-devel libXxf86vm-devel libGL-devel libX11-devel libXcm-devel libXi-devel libXv-devel libXext-devel libGLU-devel
BuildRequires: libopenal-devel libvorbis-devel libzstd-devel doxygen  libgraphviz-devel libgmp-devel libpq-devel
#libdotconf-devel graphviz
BuildRequires: libfreetype-devel
BuildRequires: systemd
BuildRequires: gettext-tools
BuildRequires: libcurl-devel
BuildRequires: libuuid-devel
BuildRequires: libbrotli-devel
%ifnarch %e2k
BuildRequires: libluajit-devel
%else
BuildRequires: libluajit-e2k-devel
%endif

BuildRequires: libncurses-devel
BuildRequires: libleveldb-devel libhiredis-devel
BuildRequires: spatialindex-devel jsoncpp-devel libpcre-devel

Requires: %name-server = %version-%release
Requires: icon-theme-hicolor

# Extra deps for irrlichtMT:
BuildRequires:  pkgconfig(xcursor)
BuildRequires:  pkgconfig(xext)
BuildRequires:  pkgconfig(xft)
BuildRequires:  pkgconfig(xxf86vm)
Provides: luanti


%description 
Game of mining, crafting and building in the infinite world of cubic
blocks with optional hostile creatures, features both single and the
network multiplayer mode.

%package server
Summary: Minetest multiplayer server
Group: Games/Other

Requires(pre): shadow-utils
Provides: luanti-server
%description server
Minetest multiplayer server. This package does not require X Window
System.

%prep
#%setup -q -n %gitname-%name
%setup -q -n luanti-%{version}
# -a 1 -a 2
%patch0 -p1
%patch1 -p1

pushd games
tar xf %SOURCE6
mv %{name}_game-5.8.0 %{name}_game
popd

cp %SOURCE7 doc/

#tar xf %%SOURCE8
#mv irrlicht-%{irrlichtmt_version} lib/irrlichtmt

# purge bundled jsoncpp and lua, and gmp
rm -rf lib/jsoncpp lib/lua lib/gmp

find . -name .gitignore -print -delete
find . -name .travis.yml -print -delete
find . -name .luacheckrc -print -delete

%build
%ifarch aarch64
%define _lto_cflags %{nil}
%endif

%cmake_insource -GNinja\
%if_with l10n
    -DENABLE_GETTEXT=TRUE \
%endif
    -DENABLE_CURL=TRUE           \
    -DENABLE_LEVELDB=TRUE        \
    -DENABLE_LUAJIT=TRUE         \
    -DENABLE_GETTEXT=TRUE        \
    -DENABLE_SOUND=TRUE          \
    -DENABLE_SYSTEM_JSONCPP=TRUE \
    -DENABLE_SYSTEM_GMP=TRUE     \
    -DENABLE_FREETYPE=TRUE       \
    -DENABLE_REDIS=TRUE          \
    -DENABLE_POSTGRESQL=TRUE     \
    -DPostgreSQL_TYPE_INCLUDE_DIR=%{_includedir}/pgsql \
    -DBUILD_SERVER=TRUE          \
    -DJSON_INCLUDE_DIR=/usr/include/json \
    -DJTHREAD_INCLUDE_DIR=%_builddir/%name/src/jthread
    #-DJTHREAD_INCLUDE_DIR=%_builddir/%gitname-%name/src/jthread
%ninja_build

%install
%ninja_install

#mkdir -p %{buildroot}%{_datadir}/minetest/irr/media
#cp -r irr/media/Shaders %{buildroot}%{_datadir}/minetest/irr/media

# Systemd unit file
mkdir -p %buildroot%_unitdir
cp -p %SOURCE2 %buildroot%_unitdir

# /etc/rsyslog.d/minetest.conf
mkdir -p %buildroot%_sysconfdir/rsyslog.d
cp -p %SOURCE3 %buildroot%_sysconfdir/rsyslog.d/%{name}.conf

# /etc/logrotate.d/minetest
mkdir -p %buildroot/%{_sysconfdir}/logrotate.d
cp -p %SOURCE4 %buildroot/%{_sysconfdir}/logrotate.d/%{name}-server

# /var/lib/minetest directory for server data files
mkdir -p %buildroot%{_sharedstatedir}/%{name} 

# /etc/minetest.conf
mkdir -p %buildroot%{_sysconfdir}
cp -p minetest.conf.example %buildroot%{_sysconfdir}/%{name}.conf

cp -p %SOURCE5 README

%if_with l10n
%find_lang luanti
%else
touch luanti.lang
%endif

%pre server
getent group %{name} >/dev/null || groupadd -r %{name}
getent passwd %{name} >/dev/null || \
    useradd -r -g %{name} -d /var/lib/%{name} -s /sbin/nologin \
    -c "Minetest multiplayer server" %{name}
exit 0

%post server
if [ $1 -eq 1 ] ; then 
    # Initial installation 
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi

%preun server
if [ $1 -eq 0 ] ; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable %{name}.service > /dev/null 2>&1 || :
    /bin/systemctl stop %{name}.service > /dev/null 2>&1 || :
fi

%postun server
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then
    # Package upgrade, not uninstall
    /bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

%files -f luanti.lang
%doc README.md doc/lgpl-2.1.txt README
%doc %_docdir/luanti
%_bindir/%name
%{_bindir}/luanti
%{_datadir}/luanti/client
%{_datadir}/luanti/fonts
%{_datadir}/luanti/textures
#_datadir/%name
%_desktopdir/*.desktop
%_iconsdir/hicolor/scalable/apps/luanti.svg
%_iconsdir/hicolor/128x128/apps/luanti.png
%_man6dir/luanti.*
%_datadir/metainfo/org*.metainfo.xml
%{_datadir}/luanti/builtin
%_datadir/locale/sr_Cyrl/LC_MESSAGES/luanti.mo
%_datadir/locale/sr_Latn/LC_MESSAGES/luanti.mo


%files server
%doc README.md doc/lgpl-2.1.txt doc/world_format.md doc/protocol.txt README
%_bindir/%{name}server
%{_bindir}/luantiserver
%_unitdir/%{name}.service
%config(noreplace) %{_sysconfdir}/%{name}.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-server
%config(noreplace) %{_sysconfdir}/rsyslog.d/%{name}.conf
%attr(0755,minetest,minetest) %dir %{_sharedstatedir}/%{name}
%_man6dir/luantiserver.6*

%changelog
