%global vcglibver 2025.07
%define glew_version %(rpm -q --queryformat='%%{version}' glew-devel | sed -nr 's/([0-9.]+).*/\\1/p')

Name: meshlab
Version: 2025.07
Release: alt2

Summary: A system for processing and editing unstructured 3D triangular meshes
License: BSD-3-Clause AND GPL-2.0-or-later
Group: Graphics
URL: https://www.meshlab.net
VCS: https://github.com/cnr-isti-vclab/meshlab

Provides: bundled(vcglib) = %vcglibver

# Source0-url: https://github.com/cnr-isti-vclab/meshlab/archive/refs/tags/MeshLab-%version.tar.gz
Source0: %name-%version.tar
# Probably belongs in its own package, but nothing else seems to depend on it.
# Source1-url: https://github.com/cnr-isti-vclab/vcglib/archive/refs/tags/%vcglibver.tar.gz
Source1: vcglib-%vcglibver.tar

Patch1: meshlab-2025.07-MESHLAB_LIB_INSTALL_DIR-fix.patch
# adjust plugin and shader search path
Patch2: 0001-Use-same-paths-for-shader-plugin-lookup-as-used-for-.patch
# https://github.com/cnr-isti-vclab/vcglib/issues/210
Patch3: 0001-Remove-unused-return-value-in-unused-function.patch
Patch4: meshlab-2025.07-system-levmar.patch

Requires: flexiblas-netlib

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake

BuildRequires: libgomp-devel
BuildRequires: bzlib-devel
BuildRequires: pkgconfig(glew)
BuildRequires: pkgconfig(gl)
BuildRequires: pkgconfig(glu)
BuildRequires: pkgconfig(xerces-c)
BuildRequires: pkgconfig(lib3ds)
BuildRequires: levmar-devel
BuildRequires: libgmpxx-devel
BuildRequires: qhull-devel
BuildRequires: %_bindir/qhull
BuildRequires: qt5-base-devel
BuildRequires: pkgconfig(eigen3)
BuildRequires: pkgconfig(Qt5XmlPatterns)
BuildRequires: pkgconfig(Qt5Script)
BuildRequires: qt5-declarative-devel
BuildRequires: qtsoap5-devel
#BuildRequires: libexif-devel
BuildRequires: boost-devel
# disables filter_mesh_booleans plugin on e2k
# because of "incomplete type is not allowed" errors
%ifnarch %e2k
BuildRequires: cgal-devel
%endif
BuildRequires: libmuparser-devel
#BuildRequires: chrpath
#BuildRequires: patchelf
BuildRequires: desktop-file-utils
BuildRequires: ImageMagick-tools

%description
MeshLab is an open source, portable, and extensible system for the
processing and editing of unstructured 3D triangular meshes.  The
system is aimed to help the processing of the typical not-so-small
unstructured models arising in 3D scanning, providing a set of tools
for editing, cleaning, healing, inspecting, rendering and converting
these kinds of meshes.

%prep
%setup -a1
rmdir src/vcglib
mv vcglib-%vcglibver src/vcglib

%autopatch -p1

# unbundle levmar
sed -i 's/^#include "levmar.h"/#include <levmar.h>/' $(find . -name "*.h")

%ifarch %e2k
%define num_threads_fix() \
	sed -i "/num_threads( %1 )/{s/ %1 /nthreads/;s/.*/int nthreads=%1; (void)nthreads;\\n&/}" \\\
	src/meshlabplugins/filter_screened_poisson/%2
%num_threads_fix threads Src/MultiGridOctreeData{,.IsoSurface,.System}.inl
%num_threads_fix Threads.value Src/PoissonRecon.cpp
%num_threads_fix pp.ThreadsVal poisson_utils.h
sed -i "/pragma omp/{s/.*/int loop_count=mesh.vert.size();\n&/;:a;n;s/i < (int)mesh.vert.size()/i < loop_count/;ba}" \
	src/vcglib/vcg/complex/algorithms/point_outlier.h
%endif

# Remove bundled library sources, since we use the packaged libraries
rm -r src/external/glew*/*

# Change defaults for MESHLAB_ALLOW_DOWNLOAD_*
sed -i '/option/ s|\(MESHLAB_ALLOW_DOWNLOAD.*\) ON|\1 OFF|' src/external/*.cmake
grep -E 'option.*MESHLAB_ALLOW_DOWNLOAD.*' src/external/*.cmake

# set plugin and shader search path
sed -i 's|PLUGIN_DIR|QString("%{_libdir}/meshlab/plugins")|g'  src/common/globals.cpp
sed -i 's|SHADER_DIR|QString("%{_datadir}/meshlab/shaders")|g' src/common/globals.cpp

%build
%add_optflags -fopenmp -DSYSTEM_QHULL -I%_includedir/libqhull

%cmake \
	-DGLEW_VERSION=%glew_version \
	%nil
%cmake_build

%install
%cmake_install

# create desktop file
cat <<EOF >%buildroot%_desktopdir/meshlab.desktop
[Desktop Entry]
Name=MeshLab
GenericName=MeshLab 3D triangular mesh processing and editing
Exec=env QT_QPA_PLATFORM=xcb meshlab
Icon=meshlab
Terminal=false
Type=Application
Categories=Graphics;
EOF

desktop-file-validate %buildroot%_desktopdir/meshlab.desktop

# convert icon
for x in 16 32 48; do
	mkdir -p %buildroot%_iconsdir/hicolor/$x'x'$x/apps/
	  convert %buildroot%_iconsdir/hicolor/512x512/apps/%name.png \
	  -resize $x'x'$x %buildroot/%_iconsdir/hicolor/$x'x'$x/apps/%name.png
done

%files
%doc README.md
%doc docs/readme.txt
%doc docs/privacy.txt
%_bindir/%name
%_libdir/*.so
%_libdir/%name
%_datadir/%name
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/%name.png

%changelog
