%def_with merged_po
Name: menu-messages
Version: 0.3.3
Release: alt1

Group: System/Base
Summary: Localization files for Menu system
License: GPL

BuildArch: noarch
Conflicts: menu < 2.1.6

%if_with merged_po
Source0: po-merged.tar
%else 
Source0: menu-messages-20100829.tar
%endif
Source1: menu-ru-20051006.po
Source2: menu-uk-20050802.po
Source3: menu-be-20050802.po
Source4: menu_2.1.45.tar
Source5: menu-messages-20100829.tar

# temporary need
Source100: menu-file2pot
Source102: menu-messages-WM-ru.po
Source103: menu-get_menu_files

# Automatically added by buildreq on Mon Oct 29 2001
BuildRequires: gettext-tools

%description
This package includes that translations of the main menu used by the
different desktops and window managers of the distribution;
as well as translations used by specifically added features.

%prep
%if_with merged_po
%setup -q -n po
%else
%setup -q -n %name

install -m 0644 %SOURCE1 ru.po
install -m 0644 %SOURCE2 uk.po
install -m 0644 %SOURCE3 be.po
%endif

%install
mkdir -p %buildroot/%_datadir/locale

# fix norwegian bokmål in kde
[ ! -r nb.po -a -r no.po ] && cp no.po nb.po

# menu-messages files
for i in ./*.po
do
    langdir="%buildroot/%_datadir/locale/`basename ${i} .po`/LC_MESSAGES/"
    mkdir -p ${langdir}
    msgfmt -o ${langdir}/menu-messages.mo ${i}
done

%find_lang menu-messages

%post
# update_menus macro is deprecated, so we expanded it there
update_menus_bin=%_bindir/update-menus
[ -x "$update_menus_bin" ] && "$update_menus_bin" ||:


%files -f menu-messages.lang

%changelog
