%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: megaglest
Version: 3.13.0
Release: alt4
Summary: Glest is a project for making a free 3d real-time customizable strategy game
License: GPLv3
Group: Games/Strategy
Url: https://megaglest.org/
VCS: https://github.com/MegaGlest/megaglest-source.git
Source: %name-%version.tar
Source2: %name.sh
Source3: %name.png
Source4: %name.desktop
Patch0: %name-%version-%release.patch
Patch1: %name-%version-alt-fixes.patch
Patch2: %name-%version-alt-fno-common.patch
Patch3: %name-%version-upstream-wxGTK-compat.patch

BuildRequires: cmake fontconfig-devel gcc-c++ libSDL2-devel libXau-devel libXdmcp-devel libcurl-devel libftgl-devel libglew-devel libjpeg-devel
BuildRequires: liblua5-devel libopenal-devel libpng-devel libvorbis-devel libxerces-c-devel libxml2-devel
BuildRequires: libwxGTK3.2-devel
BuildRequires: openssl-devel libvlc-devel libfribidi-devel glib2-devel libminiupnpc-devel libircclient-devel

Requires: %name-data = %version

%description
Glest is a project for making a free 3d real-time customizable
strategy game. Current version is fully playable, includes
single player game against CPU controlled players, two factions
with their corresponding tech trees, units, buildings and some maps.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
sed -in '/^#include <curl\/types\.h>/d' source/shared_lib/sources/platform/posix/miniftpclient.cpp
sed -i 's#DataPath=$APPLICATIONDATAPATH#DataPath=/usr/share/games/megaglest/#g' mk/linux/glest.ini

# fix font paths
sed -i \
	-e 's:/usr/share/fonts/truetype/:/usr/share/fonts/ttf/:g' \
	source/shared_lib/sources/graphics/font.cpp

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%cmake_insource \
	-DWANT_GIT_STAMP:BOOL=OFF \
	-DCUSTOM_DATA_INSTALL_PATH="%_datadir/games/megaglest/" \
	-DWANT_STATIC_LIBS:BOOL=OFF \
	%nil

%make_build VERBOSE=1

%install
%make_install install DESTDIR=%buildroot

# let's create directory structure...
mkdir -p %buildroot{%_bindir,%_niconsdir,%_desktopdir,%_datadir/%name}

mv %buildroot%_bindir/%name %buildroot%_bindir/%name-bin

# and install what we need where we need it to be...
install -pm 755 %SOURCE2 %buildroot%_bindir/%name

install -pm 644 %SOURCE3 %buildroot%_niconsdir/%name.png
install -pm 644 %SOURCE4 %buildroot%_desktopdir/%name.desktop

rm -f %buildroot%_datadir/%name/start_megaglest_gameserver

%files
%doc docs/
%_bindir/*
%_niconsdir/%name.png
%_desktopdir/%name.desktop
%_datadir/%name/*.ini
%_datadir/%name/*.ico

%changelog
