Name: mdds
Version: 3.1.0
Release: alt1
Summary: A collection of multi-dimensional data structures and indexing algorithms

Group: Development/C++
License: MIT
Url: https://gitlab.com/mdds/mdds
# http://kohei.us/files/%%name/src/%%name-%%version.tar.bz2
Source0: %name-%version.tar.bz2
Patch: mdds-1.5.0-python3.patch

BuildRequires: boost-devel
BuildRequires: boost-devel-headers
BuildRequires: ctags
BuildRequires: doxygen
BuildRequires: gcc-c++
BuildRequires: python3-module-breathe
BuildRequires: python3-module-sphinx_rtd_theme
BuildRequires: python3-module-sphinxcontrib-applehelp
BuildRequires: python3-module-sphinxcontrib-devhelp
BuildRequires: python3-module-sphinxcontrib-htmlhelp
BuildRequires: python3-module-sphinxcontrib-jsmath
BuildRequires: python3-module-sphinxcontrib-qthelp
BuildRequires: python3-module-sphinxcontrib-serializinghtml
BuildRequires: python3-module-sphinx_piccolo_theme

%description
A collection of multi-dimensional data structures and indexing algorithms.

It implements the following data structures:
* segment tree
* flat segment tree
* rectangle set
* point quad tree
* multi type matrix
* multi type vector

See README for a brief description of the structures.

%package devel
Group: Development/C++
Summary: Headers for %name
BuildArch: noarch
Requires: boost-devel
Provides: %name-static = %version-%release

%package doc
Group: Development/C++
Summary: Docs for %name
BuildArch: noarch
Provides: %name-static = %version-%release

%description devel
Headers for %name.

%description doc
Docs for %name.

%prep
%setup
%patch -p0
# this is only used in tests
%autoreconf
sed -i -e '/^CPPFLAGS_NODEBUG=/s/=.*/="%optflags"/' configure

%build
%configure --enable-docs CXXFLAGS="-fexcess-precision=fast"
%make_build all
%make_build doc-sphinx

%check
%make_build check

%install
%makeinstall

ln -sr %buildroot/%_includedir/%name-*/%name  %buildroot/%_includedir/%name

ln -sr %buildroot/%_datadir/pkgconfig/%name-*pc %buildroot/%_datadir/pkgconfig/%name.pc

install -dm 755 %buildroot/%_docdir/%name-%version

cp -a ./doc/_build %buildroot/%_docdir/%name-%version/html
cp -a ./example %buildroot/%_docdir/%name-%version/

%files doc
%_docdir/%name-%version/*
%exclude %_docdir/%name

%files devel
%doc *.md CHANGELOG AUTHORS
%_includedir/*
%_datadir/pkgconfig/*

%changelog
