%def_disable snapshot
%def_disable static
%def_enable man

Name: mdbtools
Version: 1.0.1
Release: alt1

Summary: Utilities for use M$ Access databases under Linux
Group: Databases
License: GPL-2.0 and LGPL-2.0
Url: https://github.com/mdbtools/mdbtools

Vcs: https://github.com/mdbtools/mdbtools.git

%if_disabled snapshot
Source: %url/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

Requires: lib%name = %EVR

%define glib_ver 2.68

BuildRequires: bison flex glib2-devel >= %glib_ver libreadline-devel libunixODBC-devel
BuildRequires: bash-completion
%{?_enable_man:BuildRequires: txt2man}
%{?_enable_static:BuildRequires: glibc-devel-static glib2-devel-static}

%description
MDB Tools is a set of libraries and programs to help you use Microsoft
Access file in various settings.

%package -n lib%name
Summary: MDB Tools shared libraries
Group: System/Libraries
License: LGPL-2.0
Requires: glib2 >= %glib_ver

%description -n lib%name
MDB Tools is a set of libraries and programs to help you use Microsoft
Access file in various settings.
This package provides MDB Tools shared libraries.

%package -n lib%name-devel
Summary: MDB Tools development files and libraries
Group: Development/C
License: LGPL-2.0
Requires: lib%name = %EVR
Requires: glib2-devel >= %glib_ver

%description -n lib%name-devel
This package contains the files needed to build packages that depend on
MDB Tools libraries.

%package -n lib%name-devel-static
Summary: MDB Tools static libraries
Group: Development/C
License: LGPL-2.0
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
This package contains the libraries needed to build applications
statically linked with MDB Tools.

%prep
%setup
# always use system GLIB:
sed -i 's|\(Cflags:.*\)$|\1 -DHAVE_GLIB=1|' *.pc.in

%build
%add_optflags %(getconf LFS_CFLAGS)
%ifarch %e2k
# lcc 1.25.20 ftbfs workaround (cf. mcst#6021)
%add_optflags -Wno-error=maybe-uninitialized
%endif
%autoreconf
%configure \
    %{subst_enable static} \
    --with-unixodbc=%_prefix \
    %{subst_enable man}
%make_build

%install
%makeinstall_std

%check
%make -k check VERBOSE=1

%files
%_bindir/*
%{?_enable_man:%_man1dir/*}
%_datadir/bash-completion/completions/mdb-*
%doc AUTHORS NEWS README* TODO*

%files -n lib%name
%_libdir/*.so.*
%dir %_libdir/odbc/
%_libdir/odbc/libmdbodbc*.so

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
