%define _unpackaged_files_terminate_build 1
# implement shared libs policy on soname change!
%define soname 0
%def_disable static

Name:       mcpp
Version:    2.7.2.2
Release:    alt1

Summary:    Alternative C/C++ preprocessor

License:    BSD-2-Clause
Group:      Development/C
URL:        https://mcpp.sourceforge.net/

Source:     https://codeberg.org/museoa/mcpp/archive/%version/%name-%version.tar.gz
VCS:        https://codeberg.org/museoa/mcpp.git
Patch:     %name-%version-%release.patch

%description
C/C++ preprocessor defines and expands macros and processes '#if',
'#include' and some other directives.

MCPP is an alternative C/C++ preprocessor with the highest conformance.
It supports multiple standards: K&R, ISO C90, ISO C99, and ISO C++98.
MCPP is especially useful for debugging a source program which uses
complicated macros and also useful for checking portability of a source.

Though mcpp could be built as a replacement of GCC's resident
proprocessor or as a stand-alone program without using library build of
mcpp, this package installs only a program named 'mcpp' which links
shared library of mcpp and behaves independent from GCC.

%package -n libmcpp
Summary:    Alternative C/C++ preprocessor (library build)
Group:      Development/C

%description -n libmcpp
This package provides a library build of mcpp.

%package -n libmcpp-devel
Summary:    Alternative C/C++ preprocessor (development package for library build)
Group:      Development/C
Requires:   libmcpp = %version

%description -n libmcpp-devel
Development package for libmcpp.

%package -n libmcpp-devel-static
Summary:    Alternative C/C++ preprocessor (development static package)
Group:      Development/C
Requires:   libmcpp-devel = %version

%description -n libmcpp-devel-static
Development static package for libmcpp.

%package doc
Summary:    Alternative C/C++ preprocessor (manual for library build)
Group:      Documentation
BuildArch: noarch

%description doc
This package provides an html manual for mcpp.

%prep
%setup -q
%autopatch -p1

%build
%configure \
    %{subst_enable static} \
    --enable-mcpplib

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
make CFLAGS="%optflags"

%install
iconv -f euc-jp -t utf-8 -o doc-jp/mcpp-manual.html > doc-jp/mcpp-manual-jp.html
%makeinstall_std
rm -rf %buildroot%_docdir/%name

%files
%doc ChangeLog ChangeLog.old LICENSE NEWS README
%_man1dir/*
%_bindir/%name

%files -n libmcpp
%_libdir/libmcpp.so.%{soname}
%_libdir/libmcpp.so.%{soname}.*

%files -n libmcpp-devel
%_libdir/libmcpp.so
%_includedir/mcpp_lib.h
%_includedir/mcpp_out.h

%if_enabled static
%files -n libmcpp-devel-static
%_libdir/libmcpp.a
%endif

%files doc
%doc doc/mcpp-manual.html
%lang(ja) %doc doc-jp/mcpp-manual-jp.html

%changelog
