%define pkgname mbedtls
%define so_tls_version 14
%define so_crypto_version 7
%define so_x509_version 1
%def_disable static

%filter_from_provides /^pkgconfig(mbedcrypto)/d
%filter_from_provides /^pkgconfig(mbedtls)/d
%filter_from_provides /^pkgconfig(mbedx509)/d

Name: %pkgname-compat
Version: 2.28.10
Release: alt1

Summary: Transport Layer Security protocol suite
License: Apache-2.0 OR GPL-2.0-or-later
Group: System/Legacy libraries

Url: https://tls.mbed.org/
Packager: Nazarov Denis <nenderus@altlinux.org>

# https://github.com/ARMmbed/%pkgname/archive/v%version/%pkgname-%version.tar.gz
Source: %pkgname-%version.tar

Patch0: %pkgname-alt-gcc11.patch

BuildRequires: cmake
BuildRequires: libpkcs11-helper-devel
BuildRequires: python3-dev
BuildRequires: zlib-devel

%description
mbed TLS is a light-weight open source cryptographic and SSL/TLS
library written in C. mbed TLS makes it easy for developers to include
cryptographic and SSL/TLS capabilities in their (embedded)
applications with as little hassle as possible.

%package -n lib%pkgname%so_tls_version
Summary: Transport Layer Security protocol suite
Group: System/Legacy libraries
Conflicts: hiawatha

%description -n lib%pkgname%so_tls_version
mbed TLS is a light-weight open source cryptographic and SSL/TLS
library written in C. mbed TLS makes it easy for developers to include
cryptographic and SSL/TLS capabilities in their (embedded)
applications with as little hassle as possible.

%package -n libmbedcrypto%so_crypto_version
Summary: Cryptographic base library for mbedtls
Group: System/Legacy libraries

%description -n libmbedcrypto%so_crypto_version
This subpackage of mbedtls contains a library that exposes
cryptographic ciphers, hashes, algorithms and format support such as
AES, MD5, SHA, Elliptic Curves, BigNum, PKCS, ASN.1, BASE64.

%package -n libmbedx509-%so_x509_version
Summary: Library to work with X.509 certificates
Group: System/Legacy libraries
Conflicts: hiawatha < 10.10

%description -n libmbedx509-%so_x509_version
This subpackage of mbedtls contains a library that can read, verify
and write X.509 certificates, read/write Certificate Signing Requests
and read Certificate Revocation Lists.

%package -n lib%pkgname-compat-devel
Summary: Development files for mbed TLS
Group: Development/C
Provides: lib%{pkgname}13-devel = %EVR
Obsoletes: lib%{pkgname}13-devel <= 2.27.0-alt2
Conflicts: hiawatha
Conflicts: lib%pkgname-devel

%description -n lib%pkgname-compat-devel
Contains libraries and header files for
developing applications that use mbed TLS

%if_enabled static
%package -n lib%pkgname-compat-devel-static
Summary: Static libraries for mbed TLS
Group: Development/C
Conflicts: lib%pkgname-devel-static

%description -n lib%pkgname-compat-devel-static
Static libraries for developing applications
that use mbed TLS
%endif

%prep
%setup -n %pkgname-%version
%patch0 -p1
%ifarch %e2k
# unsupported as of lcc 1.25.17
sed -i 's,-Wformat-overflow=2,,' CMakeLists.txt
sed -i 's/-Werror/-Wno-error/' CMakeLists.txt
%add_optflags -mno-aes
%endif

%build
%add_optflags -Wno-error=calloc-transposed-args
%cmake .. \
	-DENABLE_ZLIB_SUPPORT:BOOL=TRUE \
	-DLIB_INSTALL_DIR:PATH=%_libdir \
	-DUSE_SHARED_MBEDTLS_LIBRARY:BOOL=TRUE \
%if_enabled static
	-DUSE_STATIC_MBEDTLS_LIBRARY:BOOL=TRUE \
%else
	-DUSE_STATIC_MBEDTLS_LIBRARY:BOOL=FALSE \
%endif
	-DUSE_PKCS11_HELPER_LIBRARY:BOOL=TRUE

%cmake_build

%install
%cmakeinstall_std
%__rm -rf %buildroot%_bindir

%files -n lib%pkgname%so_tls_version
%_libdir/lib%pkgname.so.*

%files -n libmbedcrypto%so_crypto_version
%_libdir/libmbedcrypto.so.*

%files -n libmbedx509-%so_x509_version
%_libdir/libmbedx509.so.*

%files -n lib%pkgname-compat-devel
%doc ChangeLog LICENSE README.md
%dir %_includedir/%pkgname
%_includedir/%pkgname
%_includedir/psa
%_includedir/everest
%_libdir/libmbedcrypto.so
%_libdir/lib%pkgname.so
%_libdir/libmbedx509.so
%_pkgconfigdir/mbedcrypto.pc
%_pkgconfigdir/mbedtls.pc
%_pkgconfigdir/mbedx509.pc

%if_enabled static
%files -n lib%pkgname-compat-devel-static
%_libdir/libmbedcrypto.a
%_libdir/lib%pkgname.a
%_libdir/libmbedx509.a
%endif

%changelog
