%define pkgname mbedtls
%define optflags_lto %nil
%define so_tls_version 21
%define so_crypto_version 16
%define so_x509_version 7
%define framework_commit 457996474728cb8e968ed21953b72f74d2f536b2
%def_disable static

%filter_from_provides /^pkgconfig(mbedcrypto)/d
%filter_from_provides /^pkgconfig(mbedtls)/d
%filter_from_provides /^pkgconfig(mbedx509)/d

Name: %pkgname-3.6
Version: 3.6.5
Release: alt1

Summary: Transport Layer Security protocol suite
License: Apache-2.0 OR GPL-2.0-or-later
Group: System/Legacy libraries

Url: https://www.trustedfirmware.org/projects/mbed-tls/
Packager: Nazarov Denis <nenderus@altlinux.org>

# https://github.com/ARMmbed/%name/archive/v%version/%pkgname-%version.tar.gz
Source: %pkgname-%version.tar
# https://github.com/Mbed-TLS/%pkgname-framework/archive/%framework_commit/%pkgname-framework-%framework_commit.tar.gz
Source1: %pkgname-framework-%framework_commit.tar

BuildRequires: cmake
BuildRequires: libssl-devel
BuildRequires: python3-dev
BuildRequires: python3-module-jsonschema
BuildRequires: python3-module-mpl_toolkits

%description
mbed TLS is a light-weight open source cryptographic and SSL/TLS
library written in C. mbed TLS makes it easy for developers to include
cryptographic and SSL/TLS capabilities in their (embedded)
applications with as little hassle as possible.

%package -n lib%pkgname%so_tls_version
Summary: Transport Layer Security protocol suite
Group: System/Legacy libraries
Conflicts: hiawatha

%description -n lib%pkgname%so_tls_version
mbed TLS is a light-weight open source cryptographic and SSL/TLS
library written in C. mbed TLS makes it easy for developers to include
cryptographic and SSL/TLS capabilities in their (embedded)
applications with as little hassle as possible.

%package -n libmbedcrypto%so_crypto_version
Summary: Cryptographic base library for mbedtls
Group: System/Legacy libraries

%description -n libmbedcrypto%so_crypto_version
This subpackage of mbedtls contains a library that exposes
cryptographic ciphers, hashes, algorithms and format support such as
AES, MD5, SHA, Elliptic Curves, BigNum, PKCS, ASN.1, BASE64.

%package -n libmbedx509-%so_x509_version
Summary: Library to work with X.509 certificates
Group: System/Legacy libraries
Conflicts: hiawatha < 10.10

%description -n libmbedx509-%so_x509_version
This subpackage of mbedtls contains a library that can read, verify
and write X.509 certificates, read/write Certificate Signing Requests
and read Certificate Revocation Lists.

%package -n lib%name-devel
Summary: Development files for mbed TLS
Group: Development/C
Conflicts: hiawatha
Conflicts: lib%pkgname-devel

%description -n lib%name-devel
Contains libraries and header files for
developing applications that use mbed TLS

%if_enabled static
%package -n lib%name-devel-static
Summary: Static libraries for mbed TLS
Group: Development/C
Conflicts: lib%pkgname-devel-static

%description -n lib%name-devel-static
Static libraries for developing applications
that use mbed TLS
%endif

%prep
%setup -n %pkgname-%version -b 1
%__mv -Tf ../%pkgname-framework-%framework_commit framework
%ifarch aarch64
%add_optflags -Wno-error=array-bounds
%endif
%ifarch %e2k
sed -i 's/-Werror/-Wno-error/g' CMakeLists.txt
%add_optflags -mno-aes
%endif

%build
%cmake .. \
	-DLIB_INSTALL_DIR:PATH=%_libdir \
	-DUSE_SHARED_MBEDTLS_LIBRARY:BOOL=TRUE \
%if_enabled static
	-DUSE_STATIC_MBEDTLS_LIBRARY:BOOL=TRUE
%else
	-DUSE_STATIC_MBEDTLS_LIBRARY:BOOL=FALSE
%endif

%cmake_build

%install
%cmakeinstall_std
%__rm -rf %buildroot%_bindir

%files -n lib%pkgname%so_tls_version
%_libdir/lib%pkgname.so.%so_tls_version
%_libdir/lib%pkgname.so.*

%files -n libmbedcrypto%so_crypto_version
%_libdir/libmbedcrypto.so.%so_crypto_version
%_libdir/libmbedcrypto.so.*

%files -n libmbedx509-%so_x509_version
%_libdir/libmbedx509.so.%so_x509_version
%_libdir/libmbedx509.so.*

%files -n lib%name-devel
%doc ChangeLog LICENSE README.md
%_includedir/%pkgname
%_includedir/psa
%_includedir/everest
%_libdir/libmbedcrypto.so
%_libdir/lib%pkgname.so
%_libdir/libmbedx509.so
%_libdir/cmake/MbedTLS
%_pkgconfigdir/mbedcrypto.pc
%_pkgconfigdir/mbedtls.pc
%_pkgconfigdir/mbedx509.pc
%if_disabled static
%_libdir/libeverest.a
%_libdir/libp256m.a
%endif

%if_enabled static
%files -n lib%name-devel-static
%_libdir/libmbedcrypto.a
%_libdir/lib%pkgname.a
%_libdir/libmbedx509.a
%_libdir/libeverest.a
%_libdir/libp256m.a
%endif

%changelog
