%set_verify_info_method relaxed

%ifarch %sbcl_arches
%define DEFAULT_LISP    sbcl
%define BUILD_SBCL	1
%else
%define DEFAULT_LISP    clisp
%define BUILD_SBCL	0
%endif

%ifarch %e2k
%define BUILD_EMACS     0
%else
%define BUILD_EMACS     1
%endif

%define BUILD_GCL	0
%define BUILD_CLISP 	1
%define BUILD_CMUCL	0

%define BUILD_LANG_ES		1
%define BUILD_LANG_ES_UTF	0
%define BUILD_LANG_PT		1
%define BUILD_LANG_PT_UTF	0
%define BUILD_LANG_PT_BR	1
%define BUILD_LANG_PT_BR_UTF	0

%define BUILD_GCL_ANSI  1

%define BUILD_XMAXIMA   1

%define BUILD_BOOK      0

%define CVS_BUILD	0

Name: maxima
Version: 5.48.1
%define maxima_version 5.48.1
Release: alt1

Summary: Maxima Computer Algebra System
License: GPLv2
Group: Sciences/Mathematics

Url: http://maxima.sourceforge.net
Packager: Ilya Mashkin <oddity@altlinux.ru>

Source0: maxima-%version.tar.gz
Source6: maxima-modes.el
%if %BUILD_BOOK
Source7: breqn-0.94.tar.bz2
%endif

Patch1: maxima-alt-desktop-i18n.patch
Patch4: maxima-ecl-ldflags.patch
Patch5: maxima-5.40.0-pdf-manual-a4-paper-size.patch

## upstreamable patches
# https://bugzilla.redhat.com/show_bug.cgi?id=837142
# https://sourceforge.net/tracker/?func=detail&aid=3539587&group_id=4933&atid=104933
Patch50: maxima-5.37.1-clisp-noreadline.patch

# Build the fasl while building the executable to avoid double initialization
Patch51: maxima-5.30.0-build-fasl.patch


## Other maxima reference docs
Source10: http://starship.python.net/crew/mike/TixMaxima/macref.pdf
Source11: http://maxima.sourceforge.net/docs/maximabook/maximabook-19-Sept-2004.pdf

BuildRequires(pre): rpm-macros-sbcl
BuildRequires: python3-devel rpm-build-python3

%description
Maxima is a full symbolic computation program.  It is full featured
doing symbolic manipulation of polynomials, matrices, rational
functions, integration, Todd-coxeter, graphing, bigfloats.  It has a
symbolic debugger source level debugger for maxima code.  Maxima is
based on the original Macsyma developed at MIT in the 1970's.  It is
quite reliable, and has good garbage collection, and no memory leaks.
It comes with hundreds of self tests.

%package common
Summary: Maxima Symbolic Computation Program. Common files
Group: Sciences/Mathematics
Provides: maxima = %version-%release

Requires: gnuplot >= 4.0.0 rlwrap maxima-bin = %version-%release
BuildRequires: sed perl texlive-collection-latexrecommended texinfo
AutoReq: yes, noshell
%description common
This package contains common files needed to run Maxima with
any lisp interpreter, documentation etc.


%if %BUILD_CLISP
%package bin-clisp
Summary: Maxima Symbolic Computation Program. Clisp binaries
Group: Sciences/Mathematics
Provides: maxima-bin = %version-%release
Requires: maxima-common = %version-%release 
BuildRequires: clisp
%description bin-clisp
Maxima binaries compiled with clisp.
%endif

%if %BUILD_GCL
%package bin-gcl
Summary: Maxima Symbolic Computation Program. GCL binaries
Group: Sciences/Mathematics
Provides: maxima-bin = %version-%release
Requires: maxima-common = %version-%release libreadline libncurses terminfo libgpm
BuildRequires: gcl >= 2.6.5
%description bin-gcl
Maxima binaries compiled with GCL (GNU Common Lisp).
%endif

%if %BUILD_CMUCL
%package bin-cmucl
Summary: Maxima Symbolic Computation Program. CMUCL binaries
Group: Sciences/Mathematics
Provides: maxima-bin = %version-%release
Requires: maxima-common = %version-%release
BuildRequires: cmucl
%description bin-cmucl
Maxima binaries compiled with CMUCL (CMU Common Lisp).
%endif

%if %BUILD_SBCL
%package bin-sbcl
Summary: Maxima Symbolic Computation Program. SBCL binaries
Group: Sciences/Mathematics
Provides: maxima-bin = %version-%release
Requires: maxima-common = %version-%release sbcl >= 1.4.12
BuildRequires: sbcl >= 1.4.12
BuildRequires: /proc
%description bin-sbcl
Maxima binaries compiled with SBCL (Steel Bank Common Lisp).
%endif

%if %BUILD_EMACS
%package -n emacs-maxima
Summary: Emacs Maxima modes
Group: Editors
Requires:  emacs emacs-mode-auctex 
BuildRequires: emacs-common
#Requires: maxima-common = %version-%release
Obsoletes: maxima-emacs
BuildArch: noarch

%description -n emacs-maxima
Set of Maxima emacs modes.
%endif

%if %BUILD_XMAXIMA
%package -n xmaxima
Summary: Maxima graphical frontend
Group: Sciences/Mathematics
Requires: maxima-common = %version-%release tk tcl
Provides: %name-xmaxima = %EVR
Obsoletes: %name-xmaxima < %EVR
%description -n xmaxima
Maxima graphical frontend written in Tcl/Tk.
%endif

%if %BUILD_LANG_ES
%package lang-es
Summary: Maxima Spanish language pack
Group: Sciences/Mathematics
#Requires: maxima-common = %version-%release
BuildArch: noarch
Provides: %name-lang-es-utf8

%description lang-es
Maxima Spanish language pack.
%endif

%if %BUILD_LANG_ES_UTF
%package lang-es-utf8
Summary: Maxima Spanish language pack (UTF-8)
Group: Sciences/Mathematics
#Requires: maxima-common = %version-%release
BuildArch: noarch

%description lang-es-utf8
Maxima Spanish language pack (UTF-8).
%endif

%if %BUILD_LANG_PT
%package lang-pt
Summary: Maxima Portuguese language pack
Group: Sciences/Mathematics
#Requires: maxima-common = %version-%release
BuildArch: noarch
Provides: %name-lang-pt-utf8
%description lang-pt
Maxima Portuguese language pack.
%endif

%if %BUILD_LANG_PT_UTF
%package lang-pt-utf8
Summary: Maxima Portuguese language pack (UTF-8)
Group: Sciences/Mathematics
#Requires: maxima-common = %version-%release
BuildArch: noarch

%description lang-pt-utf8
Maxima Portuguese language pack (UTF-8).
%endif

%if %BUILD_LANG_PT_BR
%package lang-pt_BR
Summary: Maxima Brazilian Portuguese language pack
Group: Sciences/Mathematics
#Requires: maxima-common = %version-%release
BuildArch: noarch
Provides: %name-lang-pt_BR-utf8
%description lang-pt_BR
Maxima Brazilian Portuguese language pack.
%endif

%if %BUILD_LANG_PT_BR_UTF
%package lang-pt_BR-utf8
Summary: Maxima Brazilian Portuguese language pack (UTF-8)
Group: Sciences/Mathematics
#Requires: maxima-common = %version-%release
BuildArch: noarch

%description lang-pt_BR-utf8
Maxima Brazilian Portuguese language pack (UTF-8).
%endif

%if %BUILD_BOOK
%package book
Summary: Maxima book
Group: Sciences/Mathematics
BuildRequires: ghostscript
BuildArch: noarch
%description book
Maxima book
%endif

%if %CVS_BUILD
%define maxima_dir    %_builddir/maxima
%else
%define maxima_dir    %_builddir/maxima-%maxima_version
%endif

%prep
%if %CVS_BUILD
%setup -q -b0 -nmaxima
%else
%setup -q -b0 -nmaxima-%maxima_version
%endif

%if %BUILD_BOOK
tar jxf %SOURCE7 -C doc/maximabook
%endif

#patch1 -p2
#patch4 -p1
%patch5 -p1
%patch50 -p1 -b .clisp-noreadline
#patch51 -p1 -b .build-fasl

# Set new path to maxima-index.lisp
subst 's|maxima::\*maxima-infodir\* |"%_datadir/maxima/%maxima_version/doc" |' src/cl-info.lisp

# Extra docs
install -p -m644 %{SOURCE10} .
install -D -p -m644 %{SOURCE11} doc/maximabook/maxima.pdf

sed -i -e 's|@ARCH@|%{_target_cpu}|' src/maxima.in

sed -i -e 's:/usr/local/info:/usr/share/info:' \
  interfaces/emacs/emaxima/maxima.el
sed -i -e \
  's/(defcustom\s+maxima-info-index-file\s+)(\S+)/$1\"maxima.info-16\"/' \
  interfaces/emacs/emaxima/maxima.el

# remove CVS crud
find -name CVS -type d | xargs --no-run-if-empty rm -rv
cp -pv /usr/share/gnu-config/* .


%build
export PYTHON=%{__python3}

export SBCL_HOME=%_libdir/sbcl/
%if %CVS_BUILD
./bootstrap
%endif

touch ./src/*.mk ./src/Makefile.in

%if %BUILD_GCL_ANSI
export GCL_ANSI="yes"
%else
export GCL_ANSI=""
%endif

./configure  --with-default-lisp=%DEFAULT_LISP \
%if %BUILD_CLISP
  --enable-clisp  \
%endif
%if %BUILD_GCL
  --enable-gcl    \
%endif
%if %BUILD_CMUCL
  --enable-cmucl  \
%endif
%if %BUILD_SBCL
  --enable-sbcl-exec   \
%endif
%if %BUILD_LANG_ES
  --enable-lang-es	\
%endif
%if %BUILD_LANG_ES_UTF
  --enable-lang-es-utf8	\
%endif
%if %BUILD_LANG_PT
  --enable-lang-pt	\
%endif
%if %BUILD_LANG_PT_UTF
  --enable-lang-pt-utf8	\
%endif
%if %BUILD_LANG_PT_BR
  --enable-lang-pt_BR		\
%endif
%if %BUILD_LANG_PT_BR_UTF
  --enable-lang-pt_BR-utf8	\
%endif
  --prefix=%prefix           \
  --infodir=%_infodir        \
  --mandir=%_mandir          \
  --libdir=%_libdir          \
  --datadir=%_datadir        \
  --libexecdir=%_libexecdir

make

pushd doc
  %if %BUILD_BOOK
  pushd maximabook
    make pdf-final
  popd
  %endif
  # comment 25112010 3str:
  #pushd intromax
  #    pdflatex intromax.ltx
  # popd
popd  

%install
#export RPM_FINDREQ_METHOD=none
#%define _findreq_default_method none
# info files must be uncompressed
%define _compress_method no

%define maxima_libdir 	  %buildroot%_libdir/maxima
%define maxima_bindir     %buildroot%_bindir
%if %BUILD_EMACS
%define emacs_maxima_dir  %_datadir/emacs/site-lisp/maxima
%endif

# extra dirs and files not handled by standard make install

#  emacs modes
%if %BUILD_EMACS
install -d %buildroot%emacs_maxima_dir
install -d %buildroot%_sysconfdir/emacs/site-start.d
install -d %buildroot%_datadir/texmf/tex/latex/emaxima
%endif

#  documentation
install -d %buildroot%_docdir/maxima-%version
install -d %buildroot%_docdir/maxima-%version/implementation
%if %BUILD_BOOK
install -d %buildroot%_docdir/maxima-%version/maximabook
%endif
%if %BUILD_EMACS
install -d %buildroot%_docdir/maxima-%version/emaxima
%endif

# emacs modes
%if %BUILD_EMACS
install -D -m644 %SOURCE6 %buildroot%_sysconfdir/emacs/site-start.d/maxima.el
echo "(setq load-path (cons \"%emacs_maxima_dir\" load-path))" >> \
  %buildroot%_sysconfdir/emacs/site-start.d/maxima.el
%endif

# documentation
%define maxima_docdir %buildroot%_docdir/maxima-%version
%if %BUILD_BOOK
install -D -m644 %maxima_dir/doc/maximabook/maxima.pdf %maxima_docdir/maxima.pdf
%endif
install -D -m644 %maxima_dir/doc/intromax/intromax.html %maxima_docdir/intromax.html
install -D -m644 %maxima_dir/doc/implementation/*.txt %maxima_docdir/implementation
%if %BUILD_EMACS
install -D -m644 %maxima_dir/doc/emaxima/EMaximaIntro.ps %maxima_docdir/emaxima/EMaximaIntro.ps
%endif

cd %maxima_dir
%makeinstall

%if %BUILD_EMACS
# Move emacs .el and .lisp scripts to subdirectory
mv %buildroot%_datadir/emacs/site-lisp/*.{el,lisp} %buildroot%emacs_maxima_dir
mkdir -p %buildroot%_datadir/texmf/tex/latex/emaxima
mv %buildroot%_datadir/emacs/site-lisp/*.sty %buildroot%_datadir/texmf/tex/latex/emaxima
%endif

# Move all maxima-index.lisp from /usr/share/info to maxima directory
%define doc_dir %_datadir/maxima/%maxima_version/doc
pushd %buildroot%_infodir
find . -name maxima-index.lisp | while read f;do
	d="$(dirname $f)"
	d="${d//\.\/}"
	mkdir -p %buildroot%doc_dir/$d 2>/dev/null ||:
	mv "$f" %buildroot%doc_dir/$d
	if [ "$d" == "." ]; then
		for i in `ls maxima.info*`; do
			ln -s ../../../info/$i %buildroot%doc_dir/$i
		done
	else
		for i in `ls $d/maxima.info*`; do
			ln -s ../../../../info/$i %buildroot%doc_dir/$i
		done
	fi
done
popd

cp %buildroot%_infodir/maxima-index-html.lisp %buildroot%doc_dir

# Remove disallowed ELF files in /usr/share
rm -f %buildroot%_datadir/maxima/%maxima_version/share/test_encodings/escape-double-quote

%files common
%doc doc/maximabook/maxima.pdf 
%_bindir/maxima
%_bindir/rmaxima
%_infodir/*
%if %BUILD_LANG_ES
%exclude %_infodir/es
%exclude %doc_dir/es
%endif
%if %BUILD_LANG_ES_UTF
%exclude %_infodir/es/*
%exclude %doc_dir/es/*
%endif
%if %BUILD_LANG_PT
%exclude %_infodir/pt
%exclude %doc_dir/pt
%endif
%if %BUILD_LANG_PT_UTF
%exclude %_infodir/pt/*
%exclude %doc_dir/pt/*
%endif
%if %BUILD_LANG_PT_BR
%exclude %_infodir/pt_BR
%exclude %doc_dir/pt_BR
%endif
%if %BUILD_LANG_PT_BR_UTF
%exclude %_infodir/pt/*
%exclude %doc_dir/pt/*
%endif
%_mandir/man1/maxima.1*
%dir %_libexecdir/maxima
%dir %_libexecdir/maxima/%maxima_version
%_libexecdir/maxima/%maxima_version/mgnuplot
%dir %_datadir/maxima
%dir %_datadir/maxima/%maxima_version
%_datadir/maxima/%maxima_version/demo
%_datadir/maxima/%maxima_version/doc
%_datadir/maxima/%maxima_version/share
%_datadir/maxima/%maxima_version/src
%_datadir/maxima/%maxima_version/tests
%_datadir/bash-completion/completions/*maxima
%_datadir/icons/*maxima*
%if %BUILD_LANG_ES
%exclude %_datadir/maxima/%maxima_version/doc/html/es
%endif
%if %BUILD_LANG_ES_UTF
%exclude %_datadir/maxima/%maxima_version/doc/html/es/*
%endif
%if %BUILD_LANG_PT
%exclude %_datadir/maxima/%maxima_version/doc/html/pt
%endif
%if %BUILD_LANG_PT_UTF
%exclude %_datadir/maxima/%maxima_version/doc/html/pt/*
%endif
%if %BUILD_LANG_PT_BR
%exclude %_datadir/maxima/%maxima_version/doc/html/pt_BR/*
%endif
%if %BUILD_LANG_PT_BR_UTF
%exclude %_datadir/maxima/%maxima_version/doc/html/pt_BR/*
%endif
%doc AUTHORS
%doc README
%doc README.external
%doc README-lisps.md
%doc %_docdir/maxima-%version/intromax.html
%doc %_docdir/maxima-%version/implementation

%if %BUILD_CLISP
%files bin-clisp
%dir %_libdir/maxima
%dir %_libdir/maxima/%maxima_version
%_libdir/maxima/%maxima_version/binary-clisp
%endif

%if %BUILD_GCL
%files bin-gcl
%dir %_libdir/maxima
%dir %_libdir/maxima/%maxima_version
%_libdir/maxima/%maxima_version/binary-gcl
%endif

%if %BUILD_CMUCL
%files bin-cmucl
%dir %_libdir/maxima
%dir %_libdir/maxima/%maxima_version
%_libdir/maxima/%maxima_version/binary-cmucl
%endif

%if %BUILD_SBCL
%files bin-sbcl
%dir %_libdir/maxima
%dir %_libdir/maxima/%maxima_version
%_libdir/maxima/%maxima_version/binary-sbcl
%endif

%if %BUILD_EMACS
%files -n emacs-maxima
%emacs_maxima_dir
%_sysconfdir/emacs/site-start.d/*.el
%_datadir/texmf/tex/latex/emaxima
%dir %_docdir/maxima-%version
%doc %_docdir/maxima-%version/emaxima
%endif

%if %BUILD_XMAXIMA
%files -n xmaxima
%_bindir/xmaxima
%_desktopdir/*.desktop
%dir %_datadir/maxima
%dir %_datadir/maxima/%maxima_version
%_datadir/maxima/%maxima_version/xmaxima
%_datadir/mime/packages/*.xml
%_datadir/metainfo/*.appdata.xml
%endif

%if %BUILD_BOOK
%files book
%dir %_docdir/maxima-%version
%doc %_docdir/maxima-%version/maxima.pdf
%endif

%if %BUILD_LANG_ES
%files lang-es
%_datadir/maxima/%maxima_version/doc/html/es
%_infodir/es
%doc_dir/es
%endif

%if %BUILD_LANG_ES_UTF
%files lang-es-utf8
%_datadir/maxima/%maxima_version/doc/html/es/*
%_infodir/es/*
%doc_dir/es/*
%endif

%if %BUILD_LANG_PT
%files lang-pt
%_datadir/maxima/%maxima_version/doc/html/pt
%_infodir/pt
%doc_dir/pt
%endif

%if %BUILD_LANG_PT_UTF
%files lang-pt-utf8
%_datadir/maxima/%maxima_version/doc/html/pt/*
%_infodir/pt/*
%doc_dir/pt/*
%endif

%if %BUILD_LANG_PT_BR
%files lang-pt_BR
%_datadir/maxima/%maxima_version/doc/html/pt_BR
%_infodir/pt_BR
%doc_dir/pt_BR
%endif

%if %BUILD_LANG_PT_BR_UTF
%files lang-pt_BR-utf8
%_datadir/maxima/%maxima_version/doc/html/pt_BR/*
%_infodir/pt_BR/*
%doc_dir/pt_BR/*
%endif

%changelog
