Name: maven-enforcer
Version: 3.5.0
Release: alt1

Summary: Maven Enforcer
License: Apache-2.0
Group: Development/Java
URL: http://maven.apache.org/enforcer

BuildArch: noarch

Source0: enforcer-%version-source-release.zip

BuildRequires: unzip
BuildRequires: jpackage-17-compat
BuildRequires: maven-local
BuildRequires: mvn(com.google.code.findbugs:jsr305)
BuildRequires: mvn(commons-codec:commons-codec)
BuildRequires: mvn(commons-io:commons-io)
BuildRequires: mvn(javax.annotation:javax.annotation-api)
BuildRequires: mvn(javax.inject:javax.inject)
BuildRequires: mvn(org.apache.commons:commons-lang3)
BuildRequires: mvn(org.apache.maven.plugin-tools:maven-plugin-annotations)
BuildRequires: mvn(org.apache.maven.plugins:maven-plugin-plugin)
BuildRequires: mvn(org.apache.maven.resolver:maven-resolver-api)
BuildRequires: mvn(org.apache.maven.resolver:maven-resolver-util)
BuildRequires: mvn(org.apache.maven:maven-artifact)
BuildRequires: mvn(org.apache.maven:maven-core)
BuildRequires: mvn(org.apache.maven:maven-model)
BuildRequires: mvn(org.apache.maven:maven-model-builder)
BuildRequires: mvn(org.apache.maven:maven-parent:pom:)
BuildRequires: mvn(org.apache.maven:maven-plugin-api)
BuildRequires: mvn(org.apache.maven:maven-settings)
BuildRequires: mvn(org.codehaus.plexus:plexus-classworlds)
BuildRequires: mvn(org.codehaus.plexus:plexus-utils)
BuildRequires: mvn(org.codehaus.plexus:plexus-xml)
BuildRequires: mvn(org.eclipse.sisu:org.eclipse.sisu.plexus)
BuildRequires: mvn(org.eclipse.sisu:sisu-maven-plugin)
BuildRequires: mvn(org.slf4j:slf4j-api)

%description
Enforcer is a build rule execution framework.

%{?javadoc}

%package api
Group: Development/Java
Summary: Enforcer API
Provides: maven-shared-enforcer-rule-api = %{version}-%{release}

%description api
This component provides the generic interfaces needed to
implement custom rules for the maven-enforcer-plugin.

%package rules
Group: Development/Java
Summary: Enforcer Rules

%description rules
This component contains the standard Enforcer Rules.

%package plugin
Group: Development/Java
Summary: Enforcer Rules

%description plugin
This component contains the standard Enforcer Rules.

%prep
%setup -n enforcer-%version
find -name '*.java' -exec sed -i 's/\r//' {} +
find -name EvaluateBeanshell.java -delete
%pom_remove_dep :bsh enforcer-rules
 
%build
# Use system version of maven-enforcer-plugin instead of reactor version
%mvn_build -j -s -f -- -Dversion.maven-enforcer-plugin=SYSTEM

%install
%mvn_install

%files -f .mfiles-enforcer
%doc LICENSE NOTICE

%files api -f .mfiles-enforcer-api
%doc LICENSE NOTICE

%files rules -f .mfiles-enforcer-rules

%files plugin -f .mfiles-maven-enforcer-plugin

%changelog
