%define _unpackaged_files_terminate_build 1
%def_with check

Name: mackup
Version: 0.10.0
Release: alt1
Summary: Keep your application settings in sync
License: GPL-3.0
Group: Other
Url: https://pypi.org/project/mackup
VCS: https://github.com/lra/mackup

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
Requires: python3-module-%name

%if_with check
BuildRequires: python3-module-docopt
BuildRequires: python3-module-pytest
BuildRequires: python3-modules-sqlite3
BuildRequires: /proc
%endif

%description
What does it do:
- Back ups your application settings in a safe directory (e.g. Dropbox)
- Syncs your application settings among all your workstations
- Restores your configuration on any fresh install in one command line
By only tracking pure configuration files, it keeps the crap out of your
freshly new installed workstation (no cache, temporary and locally specificfiles
are transfered). Mackup makes setting up the environment easy and simple, saving
time for your family, great ideas, and all the cool stuff you like.

%package -n python3-module-%name
Summary: Keep your application settings in sync
Group: Other
BuildArch: noarch

%description -n python3-module-%name
This package contains python module for %name

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest

%files
%_bindir/%name
%doc LICENSE doc/README.md

%files -n python3-module-%name
%python3_sitelibdir/%name
%python3_sitelibdir/%{pyproject_distinfo %name}

%changelog
