Name:		lxcfs
Version:	6.0.5
Release:	alt1
Summary:	FUSE filesystem for LXC

Group:		Development/Other
License:	LGPL-2.1-or-later
URL:		https://github.com/lxc/lxcfs

VCS:		https://github.com/lxc/lxcfs.git
Source0:	%name-%version.tar
Source1:	lxcfs.sysvinit

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson >= 0.61 python3-module-jinja2
BuildRequires: libfuse3-devel
BuildRequires: pkgconfig(systemd)
BuildRequires: help2man

%define _check_contents_method relaxed

%description
FUSE filesystem for LXC, offering the following features:
 - a cgroupfs compatible view for unprivileged containers
 - a set of cgroup-aware files:
   - cpuinfo
   - meminfo
   - stat
   - uptime

%prep
%setup
sed -i 's|/bin/fusermount |/usr/bin/fusermount3|' config/init/systemd/lxcfs.service.in

%build
%meson \
    -Dinit-script=systemd

%meson_build

%install
%meson_install

mkdir -p %buildroot%_localstatedir/%name
install -Dm0755 %SOURCE1 %buildroot%_initdir/lxcfs

find %buildroot -name '*.la' -delete

%post
%post_service %name

%preun
%preun_service %name

%files
%doc AUTHORS COPYING README.md
%_bindir/%name
%_libdir/%name/lib%name.so
%_man1dir/%name.1*
%_initdir/%name
%_unitdir/%name.service
%_datadir/lxc/config/common.conf.d/*
%_datadir/%name
%dir %_localstatedir/%name

%changelog
