%define _unpackaged_files_terminate_build 1
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%define sover 1
%def_disable static_init

# Skip automatic dependency to optional lsb scripts
%add_findreq_skiplist %_initdir/*

# Needed to disable auto requirements from distro templates
%add_findreq_skiplist %_datadir/lxc/*

# Do not need to check
%add_findreq_skiplist %_libexecdir/lxc/lxc-apparmor-load
%add_findreq_skiplist %_libexecdir/lxc/lxc-net

Name: lxc
Version: 6.0.5
Release: alt1
Summary: Linux Containers
License: LGPL-2.1-or-later
Group: System/Configuration/Other
Url: https://linuxcontainers.org/

VCS: https://github.com/lxc/lxc.git
Source0: lxc-%version.tar
Source1: lxc-net.sysconfig
Source2: lxc-user-nic.control
Source3: lxc.watch
Source4: 30-lxc-inotify.conf

# git://git.altlinux.org:/gears/l/lxc.git
Patch: %name-%version-%release.patch

Requires: lxc-core lxc-net lxc-templates

BuildRequires(pre): rpm-macros-pam rpm-macros-meson
BuildRequires: meson >= 0.61
BuildRequires: docbook2X
BuildRequires: libpam-devel
BuildRequires: pkgconfig(libcap) pkgconfig(libseccomp) pkgconfig(libselinux) pkgconfig(openssl)
BuildRequires: pkgconfig(dbus-1)
%{?_enable_static_init:BuildRequires: libcap-devel-static}

%description
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This is meta package.

%package core
Summary: Core package for LXC
Group: System/Configuration/Other
Requires: rsync
Requires: service
%ifarch x86_64 aarch64 ppc64le
Requires: criu >= 3.15
%endif
Obsoletes: lxc-sysvinit < %EVR

%package net
BuildArch: noarch
Summary: Network interface for LXC with DHCP
Group: System/Configuration/Networking
Requires: iproute2 dnsmasq lxc-core iptables

%package templates
BuildArch: noarch
Summary: Templates for LXC
Group: System/Configuration/Other
Requires: lxc-core wget

%package -n liblxc%sover
Summary: LXC shared runtime library
Group: System/Libraries
Requires: lxc-runtime

%package runtime
Summary: Runtime files for LXC
Group: System/Configuration/Other
Provides: lxc-libs = %EVR
Obsoletes: lxc-libs < %EVR

%package -n liblxc-devel
Summary: Development files for LXC
Group: Development/Other
Provides: lxc-devel = %EVR

%set_pam_name pam_cgfs
%package -n %pam_name
Summary: %summary
Group: System/Base

%description core
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package provides the lxc-* tools, which can be used to start a single
daemon in a container, or to boot an entire "containerized" system, and to
manage and debug your containers.

%description net
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package provides the network interface for containers with DHCP.

%description templates
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package contains templates for LXC.

%description -n liblxc%sover
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package contains runtime shared library for LXC.

%description runtime
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package contains runtime executables and data for LXC.

%description -n liblxc-devel
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package contains development files for LXC.

%description -n %pam_name
%summary
This package provides a Pluggable Authentication Module (PAM) to provide
logged-in users with a set of cgroups which they can administer.
This allows for instance unprivileged containers, and session
management using cgroup process tracking.

%prep
%setup
%autopatch -p1
%ifarch %e2k
echo -e "#undef ARRAY_SIZE\n#define ARRAY_SIZE(x) (sizeof(x)/sizeof(*(x)))" >> src/lxc/macro.h
%endif

%build
%meson \
    -Ddistrosysconfdir='%_sysconfdir/sysconfig' \
    -Dinit-script=systemd,sysvinit \
    -Dsystemd-unitdir=%_unitdir \
    -Dcapabilities=true \
    -Dapparmor=false \
    -Dselinux=true \
    -Dseccomp=true \
    -Dpam-cgroup=true \
    -Dcgroup-pattern='lxc/%%n'

%meson_build

%install
%meson_install
mkdir -p %buildroot%_initdir
mv %buildroot%_sysconfdir/init.d/* %buildroot%_initdir/
mv %buildroot%_initdir/lxc-containers %buildroot%_initdir/lxc
mkdir -p %buildroot%_localstatedir/lxc
install -pm644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/lxc-net
install -pDm755 %SOURCE2 %buildroot%_controldir/lxc-user-nic
install -pDm644 %SOURCE4 %buildroot%_sysctldir/30-lxc-inotify.conf

rm %buildroot%_datadir/lxc/lxc-patch.py
find %buildroot -name '*.a' -delete

%post core
usermod --add-subgids 100000-165535 --add-subuids 100000-165535 root ||:
if [ $1 -eq 1 ] && ! sd_booted; then
	chkconfig --add lxc ||:
fi
%post_service_posttrans_restart lxc-monitord

%preun core
%preun_service lxc
%preun_service lxc-monitord

%post net
if [ $1 -eq 1 ] && ! sd_booted; then
	chkconfig --add lxc-net ||:
fi

%preun net
%preun_service lxc-net

%pre runtime
groupadd -r -f vmusers ||:
%pre_control lxc-user-nic

%post runtime
%post_control -s vmusers lxc-user-nic

%files

%files core
%doc COPYING doc/FAQ.txt

%dir %_sysconfdir/lxc
%dir %_sysconfdir/sysconfig/lxc
%config(noreplace) %_sysconfdir/lxc/*
%config(noreplace) %_sysconfdir/sysconfig/lxc*
%_sysctldir/30-lxc-inotify.conf
%_datadir/bash-completion/completions/*

%_bindir/lxc-*
%_datadir/lxc/config
%_datadir/lxc/selinux

%dir %_defaultdocdir/lxc
%_defaultdocdir/lxc/examples

%_man1dir/lxc*
%_man5dir/lxc*
%_man7dir/lxc*
%_mandir/ja/*/lxc*
%_mandir/ko/*/lxc*

%_initdir/lxc
%_unitdir/lxc.service
%_unitdir/lxc@.service
%_unitdir/lxc-monitord.service

%files net
%_libexecdir/lxc/lxc-net
%_initdir/lxc-net
%_unitdir/lxc-net.service

%files templates
%dir %_datadir/lxc
%_datadir/lxc/templates

%files -n liblxc%sover
%_libdir/liblxc.so.%sover
%_libdir/liblxc.so.%sover.*

%files runtime
%attr(4710,root,vmusers) %_libexecdir/lxc/lxc-user-nic
%_libexecdir/lxc/lxc-containers

%_libexecdir/lxc/lxc-apparmor-load
%_libexecdir/lxc/lxc-containers
%_libexecdir/lxc/lxc-monitord
%_libexecdir/lxc/hooks

%_controldir/lxc-user-nic
%_datadir/lxc/hooks
%_datadir/lxc/lxc.functions

%_sbindir/init.lxc*
%_localstatedir/lxc

%dir %_datadir/lxc
%dir %_libexecdir/lxc
%dir %_libdir/lxc
%dir %_libdir/lxc/rootfs
%_libdir/lxc/rootfs/README

%files -n liblxc-devel
%_includedir/lxc
%_libdir/liblxc.so
%_pkgconfigdir/lxc.pc

%files -n %pam_name
%_pam_modules_dir/*
%_man8dir/pam_cgfs.8*
%_mandir/ja/*/pam_cgfs*

%changelog
