%define target_lua_version 5.4

# Original package name tl
%define oname tl
%define oversion 0.24.8-1
%define rockspec tl-0.24.8-1.rockspec
Name: lua%target_lua_version-module-%oname
Version: 0.24.8
Release: alt1_lr1
Summary: Teal, a typed dialect of Lua
License: MIT
Group: Development/Other
Url: https://github.com/teal-language/tl

Source: https://github.com/teal-language/tl/archive/refs/tags/v0.24.8.tar.gz#/%oname-%version.tar.gz
Source1: https://luarocks.org/manifests/hisham/tl-0.24.8-1.rockspec

BuildArch: noarch
BuildPreReq: rpm-macros-lua >= 1.5.2 rpm-build-lua
BuildRequires: lua%target_lua_version-luarocks lua5.3-luarocks lua5.1-luarocks
BuildRequires: luarocks%target_lua_version(argparse) lua5.3(argparse) lua5.1(argparse)

%description
The goal of the language is to be a dialect of Lua as much as TypeScript is a
dialect of JavaScript. So yes, it is on the one hand a different language (there
are new keywords such as global for example) but on the other hand it is pretty
much recognizable, as you said, as "Lua + typing".

It aims to integrate to pretty much any Lua environment, since it's a "transpiler"
that generates plain Lua and has no dependencies. The goal is to support at
least both the latest PUC-Rio Lua and the latest LuaJIT as output targets.

%package -n lua5.3-module-%oname
Summary: Teal, a typed dialect of Lua
Group: Development/Other
%description -n lua5.3-module-%oname
The goal of the language is to be a dialect of Lua as much as TypeScript is a
dialect of JavaScript. So yes, it is on the one hand a different language (there
are new keywords such as global for example) but on the other hand it is pretty
much recognizable, as you said, as "Lua + typing".

It aims to integrate to pretty much any Lua environment, since it's a "transpiler"
that generates plain Lua and has no dependencies. The goal is to support at
least both the latest PUC-Rio Lua and the latest LuaJIT as output targets.

%package -n lua5.1-module-%oname
Summary: Teal, a typed dialect of Lua
Group: Development/Other
%description -n lua5.1-module-%oname
The goal of the language is to be a dialect of Lua as much as TypeScript is a
dialect of JavaScript. So yes, it is on the one hand a different language (there
are new keywords such as global for example) but on the other hand it is pretty
much recognizable, as you said, as "Lua + typing".

It aims to integrate to pretty much any Lua environment, since it's a "transpiler"
that generates plain Lua and has no dependencies. The goal is to support at
least both the latest PUC-Rio Lua and the latest LuaJIT as output targets.

%prep
%setup -n %oname-%version
sed -i 's/"compat53/-- "compat53/;
	/test_dependencies/,/}/ d' %SOURCE1
rm -f ./luarocks.lock

%install
%luarocks_make %SOURCE1
%luarocks_move_docs doc
# FIXME: move to rpm-macros-lua
echo Fixing Lua interpreter path
find %buildroot%_bindir -type f -name '*.lua' \
  -exec grep 'env lua$' {} \; \
  -exec subst '1 s/env lua$/env lua%target_lua_version/' '{}' ';' \
  -print

%check
%lua_path_add_buildroot
[ -x /usr/bin/busted ] && busted
make selfbuild LUA=%lua

%add_findreq_skiplist %luarocks_dbdir_prefix-*/%oname/*/{doc,docs,etc,examples,samples,spec,test}/*

%files
%_bindir/%oname
%_bindir/%oname-%target_lua_version
%lua54_modulesdir_noarch/*
%luarocks_dbdir_prefix-%target_lua_version/%oname
%doc docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-%target_lua_version/manifest

%files -n lua5.3-module-%oname
%_bindir/%oname-5.3
%lua53_modulesdir_noarch/*
%luarocks_dbdir_prefix-5.3/%oname
%doc docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-5.3/manifest

%files -n lua5.1-module-%oname
%_bindir/%oname-5.1
%lua51_modulesdir_noarch/*
%luarocks_dbdir_prefix-5.1/%oname
%doc docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-5.1/manifest

%changelog
