%define target_lua_version 5.4

# Original package name teal-language-server
%define oname teal-language-server
%define oversion 0.1.1-1
%define rockspec teal-language-server-0.1.1-1.rockspec
Name: lua%target_lua_version-module-%oname
Version: 0.1.1
Release: alt1_lr1
Summary: A language server for the Teal language
License: MIT
Group: Development/Other
Url: https://github.com/teal-language/teal-language-server

Source: https://github.com/teal-language/teal-language-server/archive/refs/tags/0.1.1.tar.gz#/%oname-%version.tar.gz
Source1: https://luarocks.org/manifests/svermeulen/teal-language-server-0.1.1-1.rockspec

BuildArch: noarch
BuildPreReq: rpm-macros-lua >= 1.5.2 rpm-build-lua
BuildRequires: lua%target_lua_version-luarocks
# lua5.3-luarocks lua5.1-luarocks
BuildRequires: luarocks%target_lua_version(luafilesystem) luarocks%target_lua_version(tl) luarocks%target_lua_version(lua-cjson) luarocks%target_lua_version(argparse) luarocks%target_lua_version(inspect) luarocks%target_lua_version(luv) luarocks%target_lua_version(lusc_luv) >= 4.0 luarocks%target_lua_version(ltreesitter) = 0.0.7 luarocks%target_lua_version(tree-sitter-teal) = 0.0.33 luarocks%target_lua_version(luarocks-build-treesitter-parser) >= 6.0.0

Requires: lua%target_lua_version-module-tree-sitter-teal

%description
A language server for the Teal language

%if 0
BuildRequires: luarocks5.1(luafilesystem) luarocks5.1(tl) = 0.24.4 luarocks5.1(lua-cjson) luarocks5.1(argparse) luarocks5.1(inspect) luarocks5.1(luv) luarocks5.1(lusc_luv) >= 4.0 luarocks5.1(ltreesitter) = 0.0.7 luarocks5.1(tree-sitter-teal) = 0.0.33 luarocks5.1(luarocks-build-treesitter-parser) >= 6.0.0
BuildRequires: luarocks5.3(luafilesystem) luarocks5.3(tl) = 0.24.4 luarocks5.3(lua-cjson) luarocks5.3(argparse) luarocks5.3(inspect) luarocks5.3(luv) luarocks5.3(lusc_luv) >= 4.0 luarocks5.3(ltreesitter) = 0.0.7 luarocks5.3(tree-sitter-teal) = 0.0.33 luarocks5.3(luarocks-build-treesitter-parser) >= 6.0.0

%package -n lua5.3-module-%oname
Summary: A language server for the Teal language
Group: Development/Other
Requires: lua5.3-module-tree-sitter-teal
%description -n lua5.3-module-%oname
A language server for the Teal language
%package -n lua5.1-module-%oname
Summary: A language server for the Teal language
Group: Development/Other
Requires: lua5.1-module-tree-sitter-teal
%description -n lua5.1-module-%oname
A language server for the Teal language
%endif

%prep
%setup -n %oname-%version
sed -i '
	s/tl == 0.24.4/tl ~> 0.24/
	/tree-sitter-cli/d
	s/\["ltreesitter-ts.*$/["ltreesitter"] = "0.0.7",/
	s/"ltreesitter-ts.*$/"ltreesitter == 0.0.7",/
	' %SOURCE1 luarocks.lock

%install
%luarocks_make %SOURCE1
%luarocks_move_docs doc

%check
%lua_path_add_buildroot
[ -x /usr/bin/busted ] || exit 0
luarocks-%target_lua_version test

%add_findreq_skiplist %luarocks_dbdir_prefix-*/%oname/*/{doc,docs,etc,examples,samples,spec,test}/*

%files
%_bindir/%oname
%_bindir/*-%target_lua_version
%lua54_modulesdir_noarch/*
%luarocks_dbdir_prefix-%target_lua_version/%oname
%doc docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-%target_lua_version/manifest

%if 0
%files -n lua5.3-module-%oname
%_bindir/*-5.3
%lua53_modulesdir_noarch/*
%luarocks_dbdir_prefix-5.3/%oname
%doc docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-5.3/manifest

%files -n lua5.1-module-%oname
%_bindir/*-5.1
%lua51_modulesdir_noarch/*
%luarocks_dbdir_prefix-5.1/%oname
%doc docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-5.1/manifest
%endif

%changelog
