%define target_lua_version 5.4

# Original package name luv
%define oname luv
%define oversion 1.50.0-1
%define rockspec luv-1.50.0-1.rockspec
Name: lua%target_lua_version-module-%oname
Version: 1.50.0
Release: alt1_lr1
Summary: Bare libuv bindings for lua
License: Apache-2.0
Group: Development/Other
Url: https://github.com/luvit/luv

Source: https://github.com/luvit/luv/archive/refs/tags/1.50.0-1.tar.gz#/%oname-%oversion.tar.gz
Source1: https://luarocks.org/manifests/creationix/luv-1.50.0-1.rockspec

BuildPreReq: rpm-macros-lua >= 1.5.2 rpm-build-lua
BuildRequires: liblua%target_lua_version-devel lua%target_lua_version-luarocks
BuildRequires: cmake libuv-devel

%description
libuv bindings for luajit and lua 5.1/5.2/5.3/5.4.

This library makes libuv available to lua scripts. It was made for the luvit
project but should usable from nearly any lua project.

%prep
%setup -n %oname-%oversion
sed -i 's/variables = {/variables = { WITH_SHARED_LIBUV="y",/' %SOURCE1

%install
%luarocks_make %SOURCE1
%luarocks_move_docs doc
# FIXME: move to rpm-macros-lua
echo Fixing Lua interpreter path
find %buildroot -type f -name '*.lua' \
  -exec grep 'env lua$' {} \; \
  -exec subst '1 s/env lua$/env lua%target_lua_version/' '{}' ';' \
  -print

%check
%lua_path_add_buildroot
LUA_PATH="$LUA_PATH;$PWD/?.lua"
luarocks-%target_lua_version test ||: # FIXME fails

%add_findreq_skiplist %luarocks_dbdir_prefix-*/%oname/*/{doc,docs,etc,examples,samples,spec,test}/*

%files
%lua_modulesdir/*
%luarocks_dbdir_prefix-%target_lua_version/%oname
%doc docs_from_rockstree/* examples tests
%exclude %luarocks_dbdir_prefix-%target_lua_version/manifest

%changelog
