%define target_lua_version 5.4

# Original package name lua-cjson
%define oname lua-cjson
%define oversion 2.1.0.10-1
%define rockspec lua-cjson-2.1.0.10-1.rockspec
Name: lua%target_lua_version-module-%oname
Version: 2.1.0.10
Release: alt1_lr1
Summary: A fast JSON encoding/parsing module
License: MIT
Group: Development/Other
Url: http://www.kyne.com.au/~mark/software/lua-cjson.php

Source: https://github.com/openresty/lua-cjson/archive/refs/tags/2.1.0.10.tar.gz#/%oname-%version.tar.gz
Source1: https://luarocks.org/manifests/openresty/lua-cjson-2.1.0.10-1.rockspec

BuildPreReq: rpm-macros-lua >= 1.5.2 rpm-build-lua
BuildRequires: liblua%target_lua_version-devel lua%target_lua_version-luarocks

%description
        The Lua CJSON module provides JSON support for Lua. It features:
        - Fast, standards compliant encoding/parsing routines
        - Full support for JSON with UTF-8, including decoding surrogate pairs
        - Optional run-time support for common exceptions to the JSON specification
          (infinity, NaN,..)
        - No dependencies on other libraries

%prep
%setup -n %oname-%version

%install
%luarocks_make %SOURCE1
%luarocks_move_docs tests
# FIXME: move to rpm-macros-lua
echo Fixing Lua interpreter path
find %buildroot -type f -name '*.lua' \
  -exec grep 'env lua$' {} \; \
  -exec subst '1 s/env lua$/env lua%target_lua_version/' '{}' ';' \
  -print

%check
%lua_path_add_buildroot
cd tests
# FIXME: crashes for now
#lua%target_lua_version test.lua

%add_findreq_skiplist %luarocks_dbdir_prefix-*/%oname/*/{doc,docs,etc,examples,samples,spec,test}/*

%files
%_bindir/*
%lua_modulesdir/*
%lua_modulesdir_noarch/*
%luarocks_dbdir_prefix-%target_lua_version/%oname
%doc LICENSE* README* docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-%target_lua_version/manifest

%changelog
