%define target_lua_version 5.4

# Original package name ltreesitter
%define oname ltreesitter
%define oversion 0.0.7-1
%define rockspec ltreesitter-0.0.7-1.rockspec
Name: lua%target_lua_version-module-%oname
Version: 0.0.7
Release: alt1_lr1
Summary: Treesitter bindings to Lua
License: MIT
Group: Development/Other
Url: https://github.com/euclidianAce/ltreesitter

Source: https://github.com/euclidianAce/ltreesitter/archive/refs/tags/v0.0.7.tar.gz#/%oname-%version.tar.gz
Source1: https://luarocks.org/manifests/3uclidian/ltreesitter-0.0.7-1.rockspec

BuildPreReq: rpm-macros-lua >= 1.5.2 rpm-build-lua
BuildRequires: liblua%target_lua_version-devel lua%target_lua_version-luarocks
BuildRequires: libtree-sitter-devel

%description
Standalone Lua bindings to the Treesitter api (with full type definitions for Teal).

%prep
%setup -n %oname-%version

%install
%luarocks_make %SOURCE1
%luarocks_move_docs docs
# FIXME: move to rpm-macros-lua
echo Fixing Lua interpreter path
find %buildroot -type f -name '*.lua' \
  -exec grep 'env lua$' {} \; \
  -exec subst '1 s/env lua$/env lua%target_lua_version/' '{}' ';' \
  -print

%check
%lua_path_add_buildroot
[ -x /usr/bin/busted ] || exit 0
busted

%add_findreq_skiplist %luarocks_dbdir_prefix-*/%oname/*/{doc,docs,etc,examples,samples,spec,test}/*

%files
%lua_modulesdir/*
%luarocks_dbdir_prefix-%target_lua_version/%oname
%doc LICENSE* README* docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-%target_lua_version/manifest

%changelog
