%define target_lua_version 5.4

# Original package name inspect
%define oname inspect
%define oversion 3.1.3-0
%define rockspec inspect-3.1.3-0.rockspec
Name: lua%target_lua_version-module-%oname
Version: 3.1.3
Release: alt1_lr0
Summary: Lua table visualizer, ideal for debugging
License: MIT
Group: Development/Other
Url: https://github.com/kikito/inspect.lua

Source: https://github.com/kikito/inspect.lua/archive/v3.1.3.tar.gz#/%oname.lua-3.1.3.tar.gz
Source1: https://luarocks.org/manifests/luarocks/inspect-3.1.3-0.rockspec

BuildPreReq: rpm-macros-lua >= 1.5.2 rpm-build-lua
# Automatically added by buildreq on ...
BuildRequires: lua%target_lua_version-luarocks

BuildArch: noarch
BuildRequires: lua5.3-luarocks lua5.1-luarocks

%description
inspect will print out your lua tables nicely so you can debug your programs quickly. It sorts keys by type and name and handles recursive tables properly.

%package -n lua5.3-module-%oname
Summary: Lua table visualizer, ideal for debugging
Group: Development/Other
%description -n lua5.3-module-%oname
    inspect will print out your lua tables nicely so you can debug your programs quickly. It sorts keys by type and name and handles recursive tables properly.

%package -n lua5.1-module-%oname
Summary: Lua table visualizer, ideal for debugging
Group: Development/Other
%description -n lua5.1-module-%oname
inspect will print out your lua tables nicely so you can debug your programs quickly. It sorts keys by type and name and handles recursive tables properly.

%prep
%setup -n %oname.lua-%version

%install
%luarocks_make %SOURCE1
%luarocks_move_docs doc

%check
%lua_path_add_buildroot
lua%target_lua_version perf.lua
[ -x /usr/bin/busted ] || exit 0
busted

%add_findreq_skiplist %luarocks_dbdir_prefix-*/%oname/*/{doc,docs,etc,examples,samples,spec,test}/*

%files
%lua54_modulesdir_noarch/*
%luarocks_dbdir_prefix-%target_lua_version/%oname
%doc *LICENSE* docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-%target_lua_version/manifest

%files -n lua5.3-module-%oname
%lua53_modulesdir_noarch/*
%luarocks_dbdir_prefix-5.3/%oname
%doc *LICENSE* docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-5.3/manifest

%files -n lua5.1-module-%oname
%lua51_modulesdir_noarch/*
%luarocks_dbdir_prefix-5.1/%oname
%doc *LICENSE* docs_from_rockstree/*
%exclude %luarocks_dbdir_prefix-5.1/manifest

%changelog
