#TODO:
#   1. check rpath is clear
%define oname luarocks

Name: lua5.4-luarocks
Version: 3.11.1
Release: alt1
Summary: A deployment and management system for Lua modules
License: MIT
Group: Development/Tools
Url: http://www.luarocks.org
Provides: %oname = %EVR
Obsoletes: %oname < %EVR
#This is %%luarocks_dbdir_prefix-%current_lua_version
#	which is defined in rpm-macros-lua package
Provides: %_prefix/lib/luarocks/rocks-5.4
Requires: chrpath wget p7zip unzip zip
Requires: rpm-macros-lua >= 1.5.2 rpm-build-lua
%add_findreq_skiplist /usr/bin/*
Requires: lua5.4

Source: http://luarocks.org/releases/%name-%version.tar
#.gz
Source1: %oname.filetrigger
Source2: %oname-files.req.list

BuildPreReq: rpm-macros-lua >= 1.5.2 rpm-build-lua
# Automatically added by buildreq on Wed Sep 20 2017
# optimized out: lua5.3 python-base
BuildRequires: liblua5.4-devel lua5.3 lua5.1 unzip wget

%description
LuaRocks allows you to install Lua modules as self-contained
packages called "rocks", which also contain version dependency
information. This information is used both during installation,
so that when one rock is requested all rocks it depends on are
installed as well, and at run time, so that when a module is
required, the correct version is loaded. LuaRocks supports both
local and remote repositories, and multiple local rocks trees.

This is the instance for lua 5.4

%package -n lua5.3-luarocks
Summary: A deployment and management system for Lua modules
License: MIT
Group: Development/Tools
#This is %%luarocks_dbdir_prefix-%current_lua_version
#	which is defined in rpm-macros-lua package
Provides: %_prefix/lib/luarocks/rocks-5.3
Requires: chrpath wget p7zip unzip zip
Requires: rpm-macros-lua >= 1.5.2 rpm-build-lua
%add_findreq_skiplist /usr/bin/*
Requires: lua5.3
Conflicts: %oname < %EVR
Conflicts: lua5.4-luarocks < %EVR
Conflicts: lua5.4-luarocks > %EVR
Conflicts: %oname > %EVR
Conflicts: rpm-macros-lua < 1.4

%description -n lua5.3-luarocks
LuaRocks allows you to install Lua modules as self-contained
packages called "rocks", which also contain version dependency
information. This information is used both during installation,
so that when one rock is requested all rocks it depends on are
installed as well, and at run time, so that when a module is
required, the correct version is loaded. LuaRocks supports both
local and remote repositories, and multiple local rocks trees.

This is the instance for lua 5.3

%package -n lua5.1-luarocks
Summary: A deployment and management system for Lua modules
License: MIT
Group: Development/Tools
#This is %%luarocks_dbdir_prefix-%current_lua_version
#	which is defined in rpm-macros-lua package
Provides: %_prefix/lib/luarocks/rocks-5.1
Requires: chrpath wget p7zip unzip zip
Requires: rpm-macros-lua >= 1.5.2 rpm-build-lua
%add_findreq_skiplist /usr/bin/*
Requires: lua5.1
Conflicts: %oname < %EVR
Conflicts: lua5.4-luarocks < %EVR
Conflicts: lua5.4-luarocks > %EVR
Conflicts: %oname > %EVR
Conflicts: rpm-macros-lua < 1.4

%description -n lua5.1-luarocks
LuaRocks allows you to install Lua modules as self-contained
packages called "rocks", which also contain version dependency
information. This information is used both during installation,
so that when one rock is requested all rocks it depends on are
installed as well, and at run time, so that when a module is
required, the correct version is loaded. LuaRocks supports both
local and remote repositories, and multiple local rocks trees.

This is the instance for lua 5.1

%prep
%setup
#disable Lua header version check
# we don't need header files for noarch rocks
sed -i 's/for lua_h in/return 0 ; \0/' configure
# FIXME: this subst may be error prone!
subst 's/return nil, mainerr/return mainerr, mainerr/' \
	src/luarocks/deps.lua

%build
for v in 5.1 5.3 5.4; do
	cp -a . ../build-$v
	pushd ../build-$v
	./configure --prefix=%prefix --lua-version=$v \

	make
	popd
done

%install
for v in 5.1 5.3 5.4; do
	%makeinstall_std -C ../build-$v
	for f in %buildroot%_bindir/*{ks,in}; do mv $f $f-$v; done
	sed -i "s|/usr/bin/env lua$|/usr/bin/env lua$v|" %buildroot%_bindir/%{oname}*-$v
	mkdir -p %buildroot{%_datadir/lua/$v/%oname/,%luarocks_dbdir_prefix-$v/}
	#move arch-dependent parts
	# pending https://github.com/keplerproject/luarocks/issues/86
	mkdir -p %buildroot%_libdir/lua/$v/%oname
	#enable lib -> lib64 right path settings
	cat >> %buildroot%_sysconfdir/%oname/config-$v.lua <<EOF
gcc_rpath = false
lib_modules_path = "/%_lib/lua/"..lua_version
EOF
	#%%ghost
	touch %buildroot%luarocks_dbdir_prefix-$v/{index.html,manifest{,-5.{1,2,3,4}}}
done

# RPM triggers
mkdir -p %buildroot%_rpmlibdir/
install -m755 %SOURCE1 %buildroot%_rpmlibdir/
# remove dependency on luarocks
# install -m644 %SOURCE2 %buildroot%_rpmlibdir/

%add_findreq_skiplist /usr/share/lua/*/luarocks/fs/lua.lua
%add_findreq_skiplist /usr/share/lua/*/luarocks/tools/zip.lua
%add_findreq_skiplist /usr/share/lua/*/luarocks/vendor/dkjson.lua
%add_findprov_skiplist %lua51_modulesdir/%oname/*
%add_findprov_skiplist %lua53_modulesdir/%oname/*
%add_findprov_skiplist %lua54_modulesdir/%oname/*
%filter_from_requires /lua5..(luarocks.test.)/d

%files
%dir %_sysconfdir/%oname
%_sysconfdir/%oname/*-5.4.*
%_bindir/%{oname}*-5.4
%dir %_prefix/lib/luarocks
%dir %luarocks_dbdir_prefix-5.4
%ghost %luarocks_dbdir_prefix-5.4/index.html
%ghost %luarocks_dbdir_prefix-5.4/manifest*
%_rpmlibdir/%{oname}*
%lua54_modulesdir/%oname
%lua54_modulesdir_noarch/%oname
%doc COPYING README*

%files -n lua5.3-luarocks
%dir %_sysconfdir/%oname
%_sysconfdir/%oname/*-5.3.*
%_bindir/%{oname}*-5.3
%dir %_prefix/lib/luarocks
%dir %luarocks_dbdir_prefix-5.3
%ghost %luarocks_dbdir_prefix-5.3/index.html
%ghost %luarocks_dbdir_prefix-5.3/manifest*
%_rpmlibdir/%{oname}*
%lua53_modulesdir/%oname
%lua53_modulesdir_noarch/%oname
%doc COPYING README*

%files -n lua5.1-luarocks
%dir %_sysconfdir/%oname
%_sysconfdir/%oname/*-5.1.*
%_bindir/%{oname}*-5.1
%dir %_prefix/lib/luarocks
%dir %luarocks_dbdir_prefix-5.1
%ghost %luarocks_dbdir_prefix-5.1/index.html
%ghost %luarocks_dbdir_prefix-5.1/manifest*
%_rpmlibdir/%{oname}*
%lua51_modulesdir/%oname
%lua51_modulesdir_noarch/%oname
%doc COPYING README*

%changelog
