%def_disable check
%define xdg_name in.lsp_plug.lsp_plugins

%def_enable ui

%ifnarch %ix86 armh
%def_enable vst3
%endif

Name: lsp-plugins
Version: 1.2.25
Release: alt1

Summary: Linux Studio Plugins
Group: Sound
License: LGPL-3.0-or-later
Url: https://lsp-plug.in/

Vcs: https://github.com/sadko4u/lsp-plugins.git

Source: https://github.com/sadko4u/%name/releases/download/%version/%name-src-%version.tar.gz

BuildRequires(pre): rpm-build-xdg
BuildRequires: gcc-c++
BuildRequires: lv2-devel libjack-devel ladspa_sdk
BuildRequires: libsndfile-devel libcairo-devel
BuildRequires: libGL-devel libXrandr-devel
BuildRequires: %_bindir/php

#ExclusiveArch: %ix86 x86_64 aarch64 %e2k riscv64 loongarch64

%description
LSP (Linux Studio Plugins) is a collection of open-source plugins
currently compatible with LADSPA, LV2 and LinuxVST formats.

%package -n jack-%name
Summary: LSP (Linux Studio Plugins) JACK plugins
Group: Sound

%description -n jack-%name
LSP (Linux Studio Plugins) JACK plugins.

%package -n ladspa-%name
Summary: LSP (Linux Studio Plugins) LADSPA plugins
Group: Sound

%description -n ladspa-%name
LSP (Linux Studio Plugins) LADSPA plugins.

%package -n lv2-%name
Summary: LSP (Linux Studio Plugins) LV2 plugins
Group: Sound

%description -n lv2-%name
LSP (Linux Studio Plugins) LV2 plugins.

%package -n vst-%name
Summary: LSP (Linux Studio Plugins) VST%{?_enable_vst3:/3} plugins
Group: Sound

%description -n vst-%name
LSP (Linux Studio Plugins) LinuxVST plugins.

%package doc
Summary: Documentation for LSP (Linux Studio Plugins) plugins
Group: Sound
BuildArch: noarch

%description doc
Documentation for LSP (Linux Studio Plugins) plugins.

%package devel
Summary: Headers for LSP (Linux Studio Plugins) plugins
Group: Development/C++
Requires: lv2-%name = %EVR

%description devel
This package provides headers for LSP-developers.

%prep
%setup -n %name

%ifarch %e2k
sed -i "s|VSTCALLBACK __cdecl|VSTCALLBACK|" \
	modules/lsp-3rd-party/include/steinberg/vst2.h
%endif

%build
export PLATFORM=Linux BUILD_SYSTEM=Linux
export VERSION=%version
%make PREFIX=%_prefix \
    LIBDIR=%_libdir \
    FEATURES="jack ladspa lv2 vst2 %{?_enable_vst3:vst3} %{?_enable_ui:ui} doc xdg" \
    EXT_FLAGS="%optflags_default %(getconf LFS_CFLAGS)" \
    config
%make_build VERBOSE=1

%install
%makeinstall_std
rm -f %buildroot%_libdir/*.a

%check
%make check

%files -n jack-%name
%_bindir/*
%{?_enable_ui:%_libdir/liblsp-r3d-glx-lib*.so}
%dir %_libdir/%name
%_libdir/%name/lib%name-jack-%version.so
%_desktopdir/%{xdg_name}_*.desktop
%_datadir/desktop-directories/%name.directory
%_xdgmenusdir/applications-merged/%name.menu
%_iconsdir/hicolor/*/apps/%name.*
%doc CHANGELOG* README*

%{?_enable_ui:%exclude %_pkgconfigdir/lsp-r3d-glx-lib.pc}

%files -n ladspa-%name
%_libdir/ladspa/*
%doc CHANGELOG* README*

%files -n lv2-%name
%_libdir/lv2/*
%doc CHANGELOG* README*

%files -n vst-%name
%_libdir/vst/*
%{?_enable_vst3:%_libdir/vst3/*}
%doc CHANGELOG* README*

%files doc
%_defaultdocdir/%name/

%changelog
