Name: loook
Version: 0.9.0
Release: alt1

Summary: Loook searches for text strings in ODF documents

License: GPLv2
Group: Text tools
Url: https://mechtilde.de/Loook/

BuildArch: noarch

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://mechtilde.de/Loook/Downloads/loook-%version-sources.zip
Source: %name-%version.tar

BuildRequires: gettext-tools
BuildRequires: rpm-build-python3

Requires: python3
Requires: python3-modules-tkinter

BuildArch: noarch

%description
This program is a program written in Python that searches for strings
in files created by OpenOffice.org, Apache OpenOffice, LibreOffice or
StarOffice 6.0 or higher. This is especially true for all documents
that were created in the Open Document Format. In addition, it can now
also search in documents created by Microsoft Word, Excel or PowerPoint
from the 2007 version in an OOXML format.

%prep
%setup

%install
install -Dm 0755 %name.py %buildroot%_datadir/%name/%name.py
install -Dm 0644 man/%name.1 %buildroot/%_man1dir/%name.1

# symlink executable
mkdir -p %buildroot%_bindir/
ln -s %_datadir/%name/%name.py %buildroot%_bindir/%name

# install messages
for m in cs de en es fr it nl ; do
    msgfmt %name.${m}.po -o %name-%version.${m}.mo
    install -Dm 0644 %name-%version.${m}.mo %buildroot%_datadir/locale/${m}/LC_MESSAGES/%name.mo
done

%find_lang %name

install -Dm 0644 %name.png %buildroot/%_pixmapsdir/%name.png
install -Dm 0644 %name.desktop %buildroot%_desktopdir/%name.desktop

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_desktopdir/%name.desktop
%_pixmapsdir/%name.png
%_man1dir/*

%changelog
