%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict
%define soname 9
%def_without python

Name: log4cplus
Version: 2.1.2
Release: alt2
Summary: Logging library to C++
License: Apache-2.0 or BSD-2-Clause
Group: Development/C++
Url: https://sourceforge.net/projects/log4cplus/
VCS: https://github.com/log4cplus/log4cplus.git
Source: %name-%version.tar

# submodules
Source1: %name-%version-catch.tar
Source2: %name-%version-threadpool.tar

Patch1: %name-%version-alt.patch

%if_with python
BuildRequires(pre): rpm-build-python3
BuildRequires: swit
BuildRequires: python3-devel
%endif
BuildRequires: gcc-c++ doxygen graphviz

%description
log4cplus is a simple to use C++ logging API providing thread-safe,
flexible, and arbitrarily granular control over log management and
configuration.  It is modeled after the Java log4j API.

%package -n lib%name%soname
Summary: Shared libraries of logging library to C++
Group: System/Libraries

%description -n lib%name%soname
log4cplus is a simple to use C++ logging API providing thread-safe,
flexible, and arbitrarily granular control over log management and
configuration.  It is modeled after the Java log4j API.

This package contains shared libraries of log4cplus.

%package -n lib%name-devel
Summary: Development files of logging library to C++
Group: Development/C++
Requires: lib%name%soname = %EVR

%description -n lib%name-devel
log4cplus is a simple to use C++ logging API providing thread-safe,
flexible, and arbitrarily granular control over log management and
configuration.  It is modeled after the Java log4j API.

This package contains development files of log4cplus.

%if_with python

%package -n python3-module-%name
Summary: Python bindings of logging library to C++
Group: Development/Python3
Requires: lib%name%soname = %EVR
%py3_provides %name

%description -n python3-module-%name
log4cplus is a simple to use C++ logging API providing thread-safe,
flexible, and arbitrarily granular control over log management and
configuration.  It is modeled after the Java log4j API.

This package contains Python bindings of log4cplus.
%endif

%prep
%setup -a1 -a2
%patch1 -p1
%ifarch %e2k
# INTEL COMPILER is based on the EDG frontend, so the workarounds
# for it work for any compiler based on the EDG frontend.
sed -i "s/__INTEL_COMPILER/__EDG__/" include/log4cplus/config.hxx
%endif

%build
%add_optflags -D_FILE_OFFSET_BITS=64

export PYTHON=python3
export CPPFLAGS="-D_FILE_OFFSET_BITS=64"
%autoreconf
%configure \
	--enable-static=no \
	--enable-threads=yes \
	--with-working-c-locale \
	%if_with python
	--with-python \
	%endif
	%nil

sed -i 's|^\(SWIG =.*\)|\1 -py3|' $(find ./ -name Makefile)

%make_build

%install
%makeinstall_std

%check
%make check

%files -n lib%name%soname
%doc LICENSE
%doc AUTHORS ChangeLog NEWS README* TODO
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%if_with python
%files -n python3-module-%name
%python3_sitelibdir/%name
%endif

%changelog
