%define _name localsearch
%define old_name tracker-miners
%define ver_major 3.10
%define beta %nil
%define api_ver_major 3
%define api_ver %api_ver_major.0
%define xdg_name org.freedesktop.Tracker%api_ver_major
%define rdn_name org.freedesktop.LocalSearch%api_ver_major
%define _libexecdir %_prefix/libexec

Name: %_name
Version: %ver_major.1
Release: alt1%beta

Summary: Tracker is a powerfull desktop-oriented search tool and indexer
License: GPL-2.0-or-later and LGPL-2.0-or-later
Group: Databases
Url: https://wiki.gnome.org/Projects/Tracker

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version%beta.tar.xz

%add_python3_path %_libdir/%_name-%api_ver/

%def_enable xml
%def_enable poppler
%def_enable libgxps
%def_enable libexif
%def_enable libiptcdata
%def_enable libgsf
%def_enable libjpeg
%def_enable libtiff
%def_enable libpng
%def_enable raw
%def_enable libvorbis
%def_enable libflac
%def_enable exempi
%def_enable libgif
%def_enable webp
%def_enable libcue
%def_enable abiword
%def_enable dvi
%def_enable mp3
%def_enable ps
%def_enable text
%def_enable icon
%def_enable libosinfo
%def_enable playlist
%def_enable network_manager
#Has header "linux/landlock.h" : YES 
#Checking if "landlock is enabled in kernel" runs: NO (1)
#meson.build:210:4: ERROR: Problem encountered: Landlock was auto-enabled in build options, but is disabled in the kernel
%def_disable landlock
%def_enable man

%define glib_ver 2.62
%define libxml2_ver 2.6
%define poppler_ver 0.16.0
%define vorbis_ver 0.22
%define flac_ver 1.2.1
%define libexif_ver 0.6
%define libgsf_ver 1.14.24
%define exempi_ver 2.1.0
%define gee_ver 0.3
%define rest_ver 0.7
%define libosinfo_ver 0.2.9
%define libpng_ver 0.89
%define libcue_ver 2.0.0
%define gst_ver 1.10
%define libav_ver 0.8.4

Obsoletes: tracker%api_ver_major-miners < %ver_major
Obsoletes: %old_name%api_ver_major < %ver_major
Provides: tracker%api_ver_major-miners = %EVR
Provides: %old_name%api_ver_major = %EVR

BuildRequires: pkgconfig(gstreamer-1.0) >= %gst_ver pkgconfig(gstreamer-audio-1.0) >= %gst_ver
BuildRequires: pkgconfig(gstreamer-tag-1.0) >= %gst_ver

BuildRequires(pre): rpm-macros-meson rpm-build-xdg rpm-build-systemd rpm-build-gir rpm-build-python3
BuildRequires: meson
BuildRequires: pkgconfig(gudev-1.0)
BuildRequires: tinysparql-devel >= %ver_major
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libupower-devel libstemmer-devel libicu-devel
BuildRequires: libenca-devel libseccomp-devel libdbus-devel
BuildRequires: pkgconfig(systemd) pkgconfig(blkid)
BuildRequires: libavformat-devel >= %libav_ver libavcodec-devel libavutil-devel
BuildRequires: gobject-introspection-devel
BuildRequires: python3(dbusmock)
# discoverer
BuildRequires: pkgconfig(gupnp-dlna-gst-2.0)
%{?_enable_xml:BuildRequires: libxml2-devel >= %libxml2_ver}
%{?_enable_libpng:BuildRequires: libpng-devel >= %libpng_ver}
%{?_enable_raw:BuildRequires: libgexiv2-0.16-devel}
%{?_enable_poppler:BuildRequires: libpoppler-glib-devel >= %poppler_ver}
%{?_enable_libgxps:BuildRequires: libgxps-devel}
%{?_enable_libexif:BuildRequires: libexif-devel >= %libexif_ver}
%{?_enable_libiptcdata:BuildRequires: libiptcdata-devel}
%{?_enable_libgsf:BuildRequires: libgsf-devel >= %libgsf_ver}
%{?_enable_libjpeg:BuildRequires: libjpeg-devel}
%{?_enable_libtiff:BuildRequires: libtiff-devel}
%{?_enable_libvorbis:BuildRequires: libvorbis-devel >= %vorbis_ver}
%{?_enable_libvorbis:BuildRequires: libflac-devel >= %flac_ver}
%{?_enable_exempi:BuildRequires: libexempi-devel >= %exempi_ver}
%{?_enable_libgif:BuildRequires: libgif-devel}
%{?_enable_webp:BuildRequires: pkgconfig(libwebpdemux)}
%{?_enable_libcue:BuildRequires: libcue-devel >= %libcue_ver }
%{?_enable_libosinfo:BuildRequires: libosinfo-devel >= %libosinfo_ver}
%{?_enable_playlist:BuildRequires: libtotem-pl-parser-devel}
%{?_enable_network_manager:BuildRequires: libnm-devel}
%{?_enable_man:BuildRequires: asciidoc-a2x xsltproc}

%description
Tracker is a powerful desktop-neutral first class object
database, tag/metadata database, search tool and indexer.

This package provides miners for TRacker.

%prep
%setup -n %_name-%version%beta
# fix install_rpath for modules
find src/ -name "meson.build" -print0 | xargs -r0 \
sed -i 's/tracker_install_rpath/tracker_internal_libs_dir/' --

%build
%meson \
    %{subst_enable_meson_feature xml xml} \
    %{subst_enable_meson_feature poppler pdf} \
    %{subst_enable_meson_feature libgxps xps} \
    %{subst_enable_meson_feature libexif exif} \
    %{subst_enable_meson_feature libiptcdata iptc} \
    %{subst_enable_meson_feature libgsf gsf} \
    %{subst_enable_meson_feature libjpeg jpeg} \
    %{subst_enable_meson_feature libtiff tiff} \
    %{subst_enable_meson_feature libgif gif} \
    %{subst_enable_meson_feature webp webp} \
    %{subst_enable_meson_feature libpng png} \
    %{subst_enable_meson_feature raw raw} \
    %{subst_enable_meson_feature exempi xmp} \
    %{subst_enable_meson_feature libcue cue} \
    %{subst_enable_meson_bool abiword abiword} \
    %{subst_enable_meson_bool mp3 mp3} \
    %{subst_enable_meson_bool ps ps} \
    %{subst_enable_meson_bool text text} \
    %{subst_enable_meson_bool icon icon} \
    %{subst_enable_meson_feature libosinfo iso} \
    %{subst_enable_meson_feature playlist playlist} \
    %{subst_enable_meson_feature landlock landlock} \
    %{subst_enable_meson_bool man man} \
    -Dsystemd_user_services_dir='%_userunitdir'
%nil
%meson_build

%install
%meson_install
ln -sf %_name-%api_ver/libtracker-extract.so \
%buildroot%_libdir/libtracker-extract.so

%find_lang %name%api_ver_major

%files -f %name%api_ver_major.lang
%_xdgconfigdir/autostart/%name-%api_ver_major.desktop
%_bindir/%name
%_libdir/%_name-%api_ver/
# symlink
%_libdir/libtracker-extract.so
%_libexecdir/%name-%api_ver_major
%_libexecdir/%name-control-%api_ver_major
%_libexecdir/%name-extractor-%api_ver_major
%_libexecdir/%name-writeback-%api_ver_major
%_datadir/%name%api_ver_major/
%_userunitdir/%name-%api_ver_major.service
%_userunitdir/%name-control-%api_ver_major.service
%_userunitdir/%name-writeback*.service
%{?_enable_man:
%_man1dir/%name-%{api_ver_major}.1*
%_man1dir/%name.1*
%_man1dir/%name-extract.1*
%_man1dir/%name-index.1*
%_man1dir/%name-info.1*
%_man1dir/%name-inhibit.1*
%_man1dir/%name-reset.1*
%_man1dir/%name-search.1*
%_man1dir/%name-status.1*
%_man1dir/%name-tag.1*
%_man1dir/%name-writeback-%{api_ver_major}.1*
}
%_datadir/dbus-1/services/%xdg_name.Miner.Files.service
%_datadir/dbus-1/services/%xdg_name.Writeback.service
%_datadir/dbus-1/services/%xdg_name.Miner.Files.Control.service
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/dbus-1/services/%rdn_name.Control.service
%_datadir/dbus-1/services/%rdn_name.Writeback.service
%_datadir/dbus-1/interfaces/%xdg_name.Miner.xml
%_datadir/dbus-1/interfaces/%xdg_name.Miner.Files.Index.xml

%_datadir/glib-2.0/schemas/%xdg_name.Extract.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.Miner.Files.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.FTS.gschema.xml
%_datadir/glib-2.0/schemas/org.freedesktop.TrackerMiners%api_ver_major.enums.xml

%_datadir/bash-completion/completions/%name

%doc AUTHORS NEWS README*

%changelog
