%define _unpackaged_files_terminate_build 1

%filter_from_requires /python[0-9.]\+(Reporter)/d
%filter_from_requires /python[0-9.]\+(optpmap)/d
%filter_from_requires /python[0-9.]\+(libscanbuild[.].*)/d
# Self-provided by python3(lldb14.0) in a custom path.
%filter_from_requires /python[0-9.]\+(lldb)/d

%global v_major 17
%global v_majmin %v_major.0
%global v_full %v_majmin.6
%global rcsuffix %nil
%global llvm_name llvm%v_majmin
%global clang_name clang%v_majmin
%global clangd_name clangd%v_majmin
%global lld_name lld%v_majmin
%global lldb_name lldb%v_majmin
%global mlir_name mlir%v_majmin
%global polly_name polly%v_majmin
%global clang_sover %v_major
%global clang_cpp_sover %v_major
%global omp_name omp%v_majmin
%global omp_sover %v_major
# libomp has own versioning
%global omp_vmajor 5
# According to openmp/libomptarget/README.txt
%global libomptarget_arches x86_64 aarch64 ppc64le
%ifarch ppc64le
%global libomp_arch ppc64
%else
%global libomp_arch %_arch
%endif

%global llvm_default_name llvm%_llvm_version
%global clang_default_name clang%_llvm_version
%global lld_default_name lld%_llvm_version

%global llvm_prefix %_prefix/lib/llvm-%v_majmin
%global llvm_bindir %llvm_prefix/bin
%global llvm_libdir %llvm_prefix/%_lib
%global llvm_includedir %llvm_prefix/include
%global llvm_libexecdir %llvm_prefix/libexec
%global llvm_datadir %llvm_prefix/share
%global llvm_man1dir %llvm_datadir/man/man1
%global llvm_docdir %llvm_datadir/doc
%global llvm_python3_libdir %llvm_libdir/python3
%global llvm_python3_sitelibdir %llvm_python3_libdir/site-packages

# to make findreq happy with openmp
# as we don't provide libomp.so in _libdir
%add_findreq_skiplist %llvm_libdir/libompd.so
%add_findreq_skiplist %_libdir/libomptarget.so.%omp_sover
%add_findreq_skiplist %_bindir/llvm-omp-device-info-%v_major
%add_findreq_skiplist %_bindir/llvm-omp-kernel-replay-%v_major

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

# Decrease debuginfo verbosity to reduce memory consumption during final library linking
%ifarch %ix86 %arm mipsel
%define optflags_debug -g0
#define __nprocs 1
%else
%define optflags_debug -g1
%endif

# LTO-related flags are set by CMake.
# LTO causes LLVM to break badly on %%ix86 see
# https://github.com/llvm/llvm-project/issues/57740
# will enable it conditionally per platform
%global optflags_lto %nil

%define hwasan_symbolize_arches x86_64 aarch64
%ifarch riscv64 loongarch64
%def_without lldb
%else
%def_with lldb
%endif
%def_with lld
# disable openmp due soname clash
%def_without openmp

%def_disable tests
# disable clang on aarch64 due very long compile time
%ifarch x86_64 ppc64le
%def_with clang
%def_with mold
%else
%def_without clang
%def_without mold
%endif
%if_with lldb
%def_with lldb_contrib
%def_with lldb_python
%else
%def_without lldb_contrib
%def_without lldb_python
%endif

%define tarversion %v_full%rcsuffix
%if "%rcsuffix" == ""
%define mversion %v_full
%else
%define mversion %v_full%{?rcsuffix:-%rcsuffix}
%endif

Name: %llvm_name
Version: %v_full
Release: alt4.4
Summary: The LLVM Compiler Infrastructure

Group: Development/C
License: Apache-2.0 with LLVM-exception
Url: http://llvm.org
# Source-URL: https://github.com/llvm/llvm-project/releases/download/llvmorg-%mversion/llvm-project-%tarversion.src.tar.xz
Source: llvm-project-%{v_major}.tar
Patch:  clang-alt-i586-fallback.patch
Patch1: clang-alt-triple.patch
Patch2: 0001-alt-llvm-config-Ignore-wrappers-when-looking-for-current.patch
Patch3: llvm-alt-fix-linking.patch
Patch4: llvm-alt-triple.patch
Patch5: compiler-rt-alt-i586-arch.patch
Patch6: clang-AST-Use-explicit-type-erasure.patch
Patch7: clang-alt-aarch64-dynamic-linker-path.patch
Patch8: clang-tools-extra-alt-gcc-0001-clangd-satisfy-ALT-gcc-s-Werror-return-type.patch
Patch10: llvm-10-alt-python3.patch
Patch11: RH-0010-PATCH-clang-Produce-DWARF4-by-default.patch
# TODO: upstream this
# Patch11: hwasan_symbolize-python3.patch
Patch12: llvm-12-alt-mips-pcrel-personality.patch
Patch13: llvm-12-debian-mips-force-nomadd4.patch
Patch14: llvm-10-alt-riscv64-config-guess.patch
Patch17: llvm-cmake-pass-ffat-lto-objects-if-using-the-GNU-toolcha.patch
Patch18: lld-compact-unwind-encoding.h.patch
Patch19: llvm-alt-cmake-build-with-install-rpath.patch
Patch20: clang-16-alt-rocm-device-libs-path.patch
Patch22: clang-D142199.patch
Patch23: clang-alt-riscv64-dynamic-linker-path.patch
Patch24: llvm-support-python-3.13.patch
Patch101: clang-ALT-bug-40628-grecord-command-line.patch
Patch102: clang-ALT-bug-47780-Calculate-sha1-build-id-for-produced-executables.patch
Patch103: clang-alt-nvvm-libdevice.patch
Patch104: openmp-alt-soname.patch
# https://github.com/llvm/llvm-project/pull/68273
Patch105: scudo-fix-assert-capability-68273.patch

Patch200: 0001-RuntimeDyld-RISCV-Minimal-riscv64-support.patch
Patch201: 0002-RuntimeDyld-RISCV-Impleemnd-HI20-and-LO12_I-relocs.patch
Patch202: 0003-RuntimeDyld-RISCV-Add-PCREL_HI20-and-PCREL_LO12_I-re.patch
Patch203: 0004-RuntimeDyld-Minimal-LoongArch64-support.patch

# debian patches for openmp
Patch300: deb-openmp-riscv64.patch

Patch400: llvm-17.0.6-fix-build-with-gcc14.patch

%if_with clang
# https://bugs.altlinux.org/show_bug.cgi?id=34671
%set_verify_elf_method lint=skip
%endif

# ThinLTO requires /proc/cpuinfo to exist; so the same does llvm
BuildPreReq: /proc

# Obtain %%__python3 at prep stage.
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-llvm-common

BuildRequires(pre): cmake >= 3.4.3
BuildRequires: rpm-build >= 4.0.4-alt112 libncursesw-devel
BuildRequires: libstdc++-devel libffi-devel perl-Pod-Parser perl-devel
BuildRequires: python3-module-myst-parser zip zlib-devel binutils-devel ninja-build
%if_with lldb_contrib
BuildRequires: pkgconfig(libedit)
BuildRequires: pkgconfig(ncursesw)
BuildRequires: pkgconfig(liblzma)
BuildRequires: pkgconfig(libxml-2.0)
#BuildRequires: pkgconfig(lua)
BuildRequires: swig-devel
BuildRequires: python3-module-sphinx-automodapi
%if_with lldb_python
BuildRequires: python3-devel
%endif
%endif
# tooling should match the version
%if_with clang
BuildRequires: clang%{v_majmin} llvm%{v_majmin}-devel lld%{v_majmin}
%else
BuildRequires: gcc-c++
%endif
%if_with mold
BuildRequires: mold
%endif

%define requires_filesystem Requires: %name-filesystem = %EVR
%requires_filesystem
Requires: llvm >= %_llvm_version

%description
LLVM is a compiler infrastructure designed for compile-time, link-time,
runtime, and idle-time optimization of programs from arbitrary
programming languages. The compiler infrastructure includes mirror sets
of programming tools as well as libraries with equivalent functionality.

%package filesystem
Group: Development/Other
Summary: Owns the installation prefix for LLVM

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description filesystem
This package owns the installation prefix for LLVM. It is designed to be
pulled in by all non-empty LLVM packages.

%package devel
Group: Development/C
Summary: Libraries and header files for LLVM
%requires_filesystem
Requires: llvm-devel >= %_llvm_version
Requires: %name = %EVR

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description devel
This package contains library and header files needed to develop new
native programs that use the LLVM infrastructure.

%package gold
Summary: gold linker plugin for LLVM
Group: Development/Tools
%requires_filesystem
# requires: libLLVM
Requires: %name-libs

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description gold
This package contains the gold plugin for LLVM objects.

%package polly
Summary: Framework for High-Level Loop and Data-Locality Optimizations
Group: Development/C
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description polly
Polly is a high-level loop and data-locality optimizer and optimization
infrastructure for LLVM. It uses an abstract mathematical representation based
on integer polyhedron to analyze and optimize the memory access pattern of a
program.

This package contains the Polly plugin.

%package libs
Group: Development/C
Summary: LLVM shared libraries
%requires_filesystem
# We pull in the gold plugin for e. g. Clang's -flto=thin to work
# out of the box with gold.
Requires: %name-gold
Requires: %name-polly

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description libs
This package contains shared libraries needed to develop new
native programs that use LLVM.

%package doc
Summary: Documentation for LLVM
Group: Documentation
BuildArch: noarch
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description doc
Documentation for the LLVM compiler infrastructure.

%package tools
Summary: Various minor tools bundled with LLVM
Group: Development/C
BuildArch: noarch
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description tools
This package contains various tools maintained as part of LLVM, including
opt-viewer.

%package -n %clang_name
Summary: A C language family frontend for LLVM
Group: Development/C
%requires_filesystem
# clang uses various parts of GNU crt bundled with gcc.
# Should they be packaged separately?
Requires: gcc
Requires: clang >= %_llvm_version
Requires: %clang_name-support = %EVR

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clang_name
clang: noun
    1. A loud, resonant, metallic sound.
    2. The strident call of a crane or goose.
    3. C-language family front-end toolkit.

The goal of the Clang project is to create a new C, C++, Objective C
and Objective C++ front-end for the LLVM compiler. Its tools are built
as libraries and designed to be loosely-coupled and extendable.

%package -n libclang%clang_sover
Group: Development/C
Summary: clang shared library
%requires_filesystem
Requires: %clang_name-support = %EVR

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n libclang%clang_sover
The goal of the Clang project is to create a new C, C++, Objective C
and Objective C++ front-end for the LLVM compiler. Its tools are built
as libraries and designed to be loosely-coupled and extendable.

This package contains the clang shared library.

%package -n libclang-cpp%clang_cpp_sover
Group: Development/C
Summary: clang-cpp shared libraries
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n libclang-cpp%clang_cpp_sover
The goal of the Clang project is to create a new C, C++, Objective C
and Objective C++ front-end for the LLVM compiler. Its tools are built
as libraries and designed to be loosely-coupled and extendable.

This package contains the clang-cpp shared library.

%package -n %clang_name-libs
Group: Development/C
Summary: clang shared libraries
%requires_filesystem
# This is a compat package.
Requires: libclang%clang_sover = %EVR
Requires: libclang-cpp%clang_cpp_sover = %EVR

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clang_name-libs
The goal of the Clang project is to create a new C, C++, Objective C
and Objective C++ front-end for the LLVM compiler. Its tools are built
as libraries and designed to be loosely-coupled and extendable.

This package contains shared libraries for the clang compiler.

%package -n %clang_name-support
Group: Development/C
Summary: Support for Clang's shared libraries
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clang_name-support
The Clang's shared libraries implement compilers for C and C++, and thus have
to bundle additional platform support headers and libraries for use within the
compilation product. This package contains the platform support.

%package -n %clang_name-support-shared-runtimes
Group: Development/C
Summary: Shared runtimes for Clang's shared libraries
%requires_filesystem
Requires: %clang_name-support = %EVR

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clang_name-support-shared-runtimes
This package contains shared runtime libraries for Scudo and sanitizers.

%package -n %clang_name-devel
Summary: Header files for clang
Group: Development/C
%requires_filesystem
Requires: clang-devel >= %_llvm_version
Requires: %clang_name = %EVR
Requires: %clang_name-tidy-devel-static = %EVR

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clang_name-devel
This package contains header files for the Clang compiler.

%package -n %clang_name-tidy-devel-static
Summary: Static libraries for clang tidy
Group: Development/C
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clang_name-tidy-devel-static
This package contains static libraries for Clang Tidy.

%package -n %clang_name-devel-static
Summary: Static libraries for clang
Group: Development/C
%requires_filesystem
Requires: %clang_name-devel = %EVR

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clang_name-devel-static
This package contains static libraries for the Clang compiler.

%package -n %clang_name-analyzer
Summary: A source code analysis framework
Group: Development/C
BuildArch: noarch
%requires_filesystem
Requires: %clang_name = %EVR

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clang_name-analyzer
The Clang Static Analyzer consists of both a source code analysis
framework and a standalone tool that finds bugs in C and Objective-C
programs. The standalone tool is invoked from the command-line, and is
intended to run in tandem with a build of a project or code base.

%package -n %clang_name-tools
Summary: Various clang-based tools
Group: Development/C
%requires_filesystem
Requires: %clang_name = %EVR
Requires: clang-tools >= %_llvm_version

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clang_name-tools
This package contains various code analysis and manipulation tools based on
libclang, including clang-format.

%package -n %clang_name-doc
Summary: Documentation for Clang
Group: Documentation
BuildArch: noarch
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clang_name-doc
Documentation for the Clang compiler front-end.

%package -n %clangd_name
Summary: A clang-based language server
Group: Development/C
%requires_filesystem
Requires: clangd >= %_llvm_version
Requires: %clang_name-support = %EVR

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %clangd_name
This package contains clangd, a Clang-based language server for C and C++.

%package -n %lld_name
Summary: LLD - The LLVM Linker
Group: Development/C
%requires_filesystem
Requires: lld >= %_llvm_version
# /proc needed for normal operation
Requires: /proc

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %lld_name
LLD is a linker from the LLVM project. That is a drop-in replacement for system
linkers and runs much faster than them. It also provides features that are
useful for toolchain developers.

%package -n %lld_name-devel
Summary: Header files for LLD
Group: Development/C
%requires_filesystem
Requires: lld-devel >= %_llvm_version
Requires: %lld_name = %EVR

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %lld_name-devel
This package contains header files for the LLD linker.

%package -n %lld_name-doc
Summary: Documentation for LLD
Group: Documentation
BuildArch: noarch
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %lld_name-doc
Documentation for the LLD linker.

%if_with lldb
%package -n %lldb_name
Summary: A next-level high-performance debugger
Group: Development/Debuggers
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %lldb_name
LLDB is a next generation, high-performance debugger. It is built as a set of
reusable components which highly leverage existing libraries in the larger LLVM
project, such as the Clang expression parser and the LLVM disassembler.

%package -n lib%lldb_name
Summary: Shared library for LLDB
Group: Development/Debuggers
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n lib%lldb_name
This package contains the LLDB runtime library.

%package -n lib%lldb_name-devel
Summary: Development files for liblldb
Group: Development/Debuggers
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n lib%lldb_name-devel
This package contains header files to build extensions over lldb, as well as
development symlinks for liblldb.

%package -n python3-module-%lldb_name
Summary: Python 3 scripting support for LLDB
Group: Development/Debuggers
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n python3-module-%lldb_name
This package contains the Python 3 interfaces to LLDB.

%package -n %lldb_name-doc
Summary: Documentation for LLDB
Group: Documentation
BuildArch: noarch
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %lldb_name-doc
Documentation for the LLDB debugger.
%endif

%package -n lib%mlir_name
Summary: Multi-Level Intermediate Representation library
Group: Development/C
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n lib%mlir_name
MLIR is a novel approach to building reusable and extensible compiler infrastructure.
MLIR aims to address software fragmentation, improve compilation for
heterogeneous hardware, significantly reduce the cost of building domain
specific compilers, and aid in connecting existing compilers together.

%package -n lib%mlir_name-devel
Summary: Libraries and header files for MLIR
Group: Development/C
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n lib%mlir_name-devel
MLIR is a novel approach to building reusable and extensible compiler infrastructure.
MLIR aims to address software fragmentation, improve compilation for
heterogeneous hardware, significantly reduce the cost of building domain
specific compilers, and aid in connecting existing compilers together.

This package contains headers and other development files for lib%mlir_name.

%package -n %mlir_name-tools
Summary: Various mlir-based tools
Group: Development/C
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n %mlir_name-tools
MLIR is a novel approach to building reusable and extensible compiler infrastructure.
MLIR aims to address software fragmentation, improve compilation for
heterogeneous hardware, significantly reduce the cost of building domain
specific compilers, and aid in connecting existing compilers together.

This package contains some bundled tools.

%package -n lib%polly_name-devel
Summary: Development files for Polly
Group: Development/C
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n lib%polly_name-devel
Polly is a high-level loop and data-locality optimizer and optimization
infrastructure for LLVM. It uses an abstract mathematical representation based
on integer polyhedron to analyze and optimize the memory access pattern of a
program.

This package contains header files for the Polly optimizer.

%package -n lib%polly_name-doc
Summary: Documentation for Polly
Group: Development/C
BuildArch: noarch
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n lib%polly_name-doc
Polly is a high-level loop and data-locality optimizer and optimization
infrastructure for LLVM. It uses an abstract mathematical representation based
on integer polyhedron to analyze and optimize the memory access pattern of a
program.

This package contains documentation for the Polly optimizer.

%package -n lib%omp_name
Summary: LLVM/OpenMP Host Runtime (libomp)
Group: System/Libraries
%requires_filesystem

%description -n lib%omp_name
OpenMP runtime for clang.

%package -n lib%omp_name-devel
Summary: OpenMP header files
Group: Development/C
Requires: %clang_name-support = %EVR
%requires_filesystem

%description -n lib%omp_name-devel
OpenMP header files

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%package -n lib%omp_name-doc
Summary: Documentation for OpenMP
Group: Development/C
BuildArch: noarch
%requires_filesystem

# We do not want Python modules to be analyzed by rpm-build-python2.
AutoReq: nopython
AutoProv: nopython

%description -n lib%omp_name-doc
This package contains documentation for the OpenMP.

%package cmake-common-modules
Summary: LLVM common cmake modules
Group: Development/C
BuildArch: noarch
Requires: cmake-modules
%requires_filesystem

%description cmake-common-modules
These are CMake modules to be shared between LLVM projects strictly at build
time.

These modules are used by llvm runtimes built outside of llvm tree.

%prep
# %setup -n llvm-%tarversion.src -a1 -a2 -a3 -a4 -a5 -a6
# for pkg in clang lld lldb; do
   # mv $pkg-%tarversion.src tools/$pkg
# done
# mv clang-tools-extra-%tarversion.src tools/clang/tools/extra
# for pkg in compiler-rt; do
   # mv $pkg-%tarversion.src projects/$pkg
# done
%setup -n llvm-project-%{v_major}
%patch -p1 -b .alt-i586-fallback
%patch1 -p1 -b .alt-triple
%patch2 -p1
sed -i 's)"%%llvm_bindir")"%llvm_bindir")' llvm/lib/Support/Unix/Path.inc
%patch3 -p1 -b .alt-fix-linking
%patch4 -p1 -b .alt-triple
%patch5 -p1 -b .alt-i586-arch
%patch6 -p2
%patch7 -p1 -b .alt-aarch64-dynamic-linker
%patch8 -p1
%patch10 -p1
%patch11 -p1 -b .clang-DWARF4
%patch12 -p1
%patch13 -p1
%patch14 -p1
#patch15 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1 -b .llvm-cmake-build-with-install-rpath
%patch20 -p1 -b .clang-rocm-device-path
%patch22 -p1 -b .recommonmark
%patch23 -p1
%patch24 -p1
%patch101 -p1
%patch102 -p2
%patch103 -p1
%patch104 -p2
%patch105 -p1

%patch200 -p2
%patch201 -p2
%patch202 -p2
%patch203 -p2

# debian patches
%patch300 -p1

# gcc14
%patch400 -p1

# LLVM 12 and onward deprecate Python 2:
# https://releases.llvm.org/12.0.0/docs/ReleaseNotes.html
# Explicitly use python3 in hashbangs.
subst '/^#!.*python$/s|python$|python3|' $(grep -Rl '#!.*python$' *)

%build
PROJECTS="clang;clang-tools-extra;compiler-rt;mlir;polly"
%if_with lld
PROJECTS="$PROJECTS;lld"
%endif
%if_with lldb
PROJECTS="$PROJECTS;lldb"
%endif
%if_with openmp
PROJECTS="$PROJECTS;openmp"
%endif
export NPROCS="%__nprocs"
if [ "$NPROCS" -gt 64 ]; then
	export NPROCS=64
fi
%define builddir %_cmake__builddir
%define _cmake_skip_rpath -DCMAKE_SKIP_RPATH:BOOL=OFF
%add_optflags -Wno-error=return-type
%if_with clang
export ALTWRAP_LLVM_VERSION=%{v_majmin}
%endif
%cmake -G Ninja -S llvm \
	-DCMAKE_CXX_LINKER_DEPFILE_SUPPORTED:BOOL=FALSE \
	-DCMAKE_C_LINKER_DEPFILE_SUPPORTED:BOOL=FALSE \
	-DPACKAGE_VENDOR="%vendor" \
%ifnarch loongarch64
%if_with clang
	-DLLVM_PARALLEL_LINK_JOBS=1 \
%else
	-DLLVM_PARALLEL_LINK_JOBS=4 \
%endif
%endif
	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_INSTALL_PREFIX=%llvm_prefix \
	%_cmake_skip_rpath \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
	-DCMAKE_BUILD_RPATH:STRING='' \
	-DBUILD_SHARED_LIBS:BOOL=OFF \
	-DLLVM_ENABLE_PROJECTS="$PROJECTS" \
	-DLLVM_TARGETS_TO_BUILD="all" \
	-DLLVM_EXPERIMENTAL_TARGETS_TO_BUILD='AVR' \
	-DLLVM_ENABLE_LIBCXX:BOOL=OFF \
	-DLLVM_ENABLE_ZLIB:BOOL=ON \
	-DLLVM_ENABLE_FFI:BOOL=ON \
	-DLLVM_ENABLE_RTTI:BOOL=ON \
	-DLLVM_OPTIMIZED_TABLEGEN:BOOL=ON \
	-DLLVM_BINUTILS_INCDIR="%_includedir/bfd" \
	\
	-DCLANG_PLUGIN_SUPPORT:BOOL=ON \
	-DCLANG_LINK_CLANG_DYLIB=ON \
	-DCLANG_FORCE_MATCHING_LIBCLANG_SOVERSION:BOOL=ON \
	-DENABLE_LINKER_BUILD_ID:BOOL=ON \
	\
	-DTARGET_loongarch64_CFLAGS:STRING='-mcmodel=medium' \
	\
	%if_with clang
	-DCMAKE_C_COMPILER=clang \
	-DCMAKE_CXX_COMPILER=clang++ \
	-DCMAKE_RANLIB:PATH=%_bindir/llvm-ranlib \
	-DCMAKE_AR:PATH=%_bindir/llvm-ar \
	-DCMAKE_NM:PATH=%_bindir/llvm-nm \
	-DLLVM_ENABLE_LTO=Thin \
	%if_with mold
	-DLLVM_USE_LINKER=mold \
	%else
	-DLLVM_USE_LINKER=lld \
	%endif
	%else
	-DLLVM_ENABLE_LTO=Off \
	%ifnarch riscv64 loongarch64
	-DLLVM_USE_LINKER=gold \
	%endif
	-DCMAKE_AR:PATH=%_bindir/gcc-ar \
	-DCMAKE_NM:PATH=%_bindir/gcc-nm \
	-DCMAKE_RANLIB:PATH=%_bindir/gcc-ranlib \
	%endif
	\
	-DLLVM_LIBDIR_SUFFIX="%_libsuff" \
	-DLLVM_BUILD_RUNTIME:BOOL=ON \
	\
	-DLLVM_INCLUDE_TOOLS:BOOL=ON \
	-DLLVM_BUILD_TOOLS:BOOL=ON \
	\
	-DMLIR_INSTALL_AGGREGATE_OBJECTS=OFF \
	%if_with openmp
	-DLIBOMP_INSTALL_ALIASES=OFF \
	-DOPENMP_LIBDIR_SUFFIX="%_libsuff" \
	-DOPENMP_INSTALL_LIBDIR=%_libdir \
	%endif
	\
	%if_enabled tests
	-DLLVM_INCLUDE_TESTS:BOOL=ON \
	-DLLVM_BUILD_TESTS:BOOL=ON \
	-DLLDB_INCLUDE_TESTS:BOOL=ON \
	%else
		%if_with clang
		-DLLDB_TEST_COMPILER:PATH=%_bindir/clang \
		%else
		-DLLDB_TEST_COMPILER:PATH=%_bindir/gcc \
		%endif
	%endif
	%ifarch %ix86
	-DLLVM_DEFAULT_TARGET_TRIPLE:STRING="i586-pc-linux-gnu" \
	%endif
	\
	-DLLVM_INCLUDE_EXAMPLES:BOOL=ON \
	-DLLVM_BUILD_EXAMPLES:BOOL=OFF \
	\
	-DLLVM_INCLUDE_UTILS:BOOL=ON \
	-DLLVM_INSTALL_UTILS:BOOL=OFF \
	\
	-DLLVM_INCLUDE_DOCS:BOOL=ON \
	-DLLVM_BUILD_DOCS:BOOL=ON \
	-DLLVM_ENABLE_SPHINX:BOOL=ON \
	-DSPHINX_WARNINGS_AS_ERRORS:BOOL=OFF \
	-DSPHINX_EXECUTABLE=%_bindir/sphinx-build-3 \
	-DLLVM_ENABLE_DOXYGEN:BOOL=OFF \
	-DLLVM_BUILD_LLVM_DYLIB:BOOL=ON \
	-DLLVM_LINK_LLVM_DYLIB:BOOL=ON \
	-DLLVM_INSTALL_TOOLCHAIN_ONLY:BOOL=OFF \
	-DPYTHON_EXECUTABLE=%_bindir/python3

sed -i 's|man\ tools/lld/docs/docs-lld-html|man|' %builddir/build.ninja
export LD_LIBRARY_PATH=$(pwd)/%builddir/%_lib
ninja -vvv -j $NPROCS -C %builddir

%install
%if_with lld
sed -i 's|man\ tools/lld/docs/docs-lld-html|man|' %builddir/build.ninja
sed -i '/^[[:space:]]*include.*tools\/lld\/docs\/cmake_install.cmake.*/d' %builddir/tools/lld/cmake_install.cmake
%endif
DESTDIR=%buildroot ninja -C %builddir install

# scanbuild is noarch
if [ %_libsuff == 64 ]; then
mkdir -p %buildroot%llvm_prefix/lib ||:
mv %buildroot%llvm_libdir/{libear,libscanbuild} %buildroot%llvm_prefix/lib
fi

# Prepare Clang documentation.
rm -rf %builddir/clang-docs
mkdir -p %builddir/clang-docs
for f in LICENSE.TXT NOTES.txt README.txt; do
  ln clang/$f %builddir/clang-docs/
done
rm -rf tools/clang/docs/{doxygen*,Makefile*,*.graffle,tools}

install -m 0755 %builddir/%_lib/LLVMHello.so %buildroot%llvm_libdir/
install -m 0755 %builddir/%_lib/BugpointPasses.so %buildroot%llvm_libdir/
mkdir -p %buildroot%llvm_docdir/lld

%ifarch %ix86
cd %buildroot%llvm_libdir/clang/%v_major/lib/*-*-*-*
ls *-i[3-9]86* | while read f; do ln -s $f $(echo $f | sed 's|i[3-9]86|i386|') ; done
cd -
%endif

# The following files are not used by LLVM builds for Linux.
rm -f %buildroot%llvm_bindir/argdumper
rm -f %buildroot%llvm_datadir/clang/clang-format-bbedit.applescript

%if_with openmp
# Remove OpenMP static libraries with equivalent shared libraries
rm -rf %buildroot%llvm_libdir/libarcher_static.a
# FIXME! will pack it later
# those files are needed for libompd (OMP debugger)
rm -rf %buildroot%llvm_datadir/gdb
%endif

# Install the clang bash completion.
mkdir -p %buildroot%_datadir/bash-completion/completions
ln -sr %buildroot%llvm_datadir/clang/bash-autocomplete.sh %buildroot%_datadir/bash-completion/completions/clang-%v_major

# Symlink executables to %_bindir.
mkdir -p %buildroot%_bindir
for b in %buildroot%llvm_bindir/*; do
	bb="$(basename "$b")"
	echo "$bb" | grep -q -- '-%v_major$' && continue # if already appended
	ln -srv "$b" "%buildroot%_bindir/$bb-%v_major"
done
# Symlink man pages to the man dirs.
for mand in %buildroot%llvm_datadir/man/man*; do
	mand_index="${mand##*/man}"
	for m in "$mand"/*.[1-9]*; do
		# Let's force compress the man page, then symlink it.
		# /usr/lib/llvm-14.0/share/man/manD/utilX.D.xz -> /usr/share/man/manD/utilX-14.D.xz
		# Otherwise, brp-alt(compress) keeps fucking us up.
		# It remakes the symlinks first, then compresses their targets,
		# severing the symlinks.
		/usr/lib/rpm/compress_files "$m"

		mb="$(basename "$m")" # e. g. llvm-ar.1.xz
		new_mb="${mb%%.[1-9]*}-%v_major.$mand_index" # e. g. llvm-ar-12.1.xz

		mkdir -p "%buildroot%_mandir/man$mand_index"
		ln -srv "$m" "%buildroot%_mandir/man$mand_index/$new_mb"
	done
done

# Symlink sonamed shared libraries in %llvm_prefix/%_libdir to %_libdir.
mkdir -p %buildroot%_libdir
find %buildroot%llvm_libdir/*.so* -type f,l \
	| grep -E '^%buildroot%llvm_libdir/.*(%v_major)' | sort | tee %_tmppath/shared-objects \
	| sed 's)%llvm_libdir)%_libdir)' > %_tmppath/shared-object-links
paste %_tmppath/shared-objects %_tmppath/shared-object-links | while read object link; do
	ln -srv "$object" "$link"
done
%if_with openmp
# OpenMP needs special handling here
ln -srv %buildroot%llvm_libdir/libomp.so.%omp_vmajor %buildroot%_libdir/libomp.so.%omp_vmajor
%endif

# List all packaged binaries in this source package.
find %buildroot%_bindir/*-%v_major > %_tmppath/PATH-executables

# For paranoic reasons library packaging policy covers peculiar directory paths.
# If there are $A.a and $A.so in %llvm_libdir/clang, they should not end up in the
# same package (but can be co-installed on a system).
# Let's list all the $A.so for which $A.a exists into a separate package.
# We also consider i386-symlinks for iN86.
find %buildroot%llvm_libdir/clang -type f,l -name '*.a' -or -name '*.so' | \
    sed -r -n 's/^(\/.+)\.a$/\1/p; s/^(.+)\.so$/\1/p' | sort | uniq -d > %_tmppath/libclang-support-dupes
sed < %_tmppath/libclang-support-dupes 's)^%buildroot)); s/$/.a/' > %_tmppath/libclang-support-static-runtimes
sed < %_tmppath/libclang-support-dupes 's)^%buildroot)); s/$/.so/' > %_tmppath/libclang-support-shared-runtimes
sed < %_tmppath/libclang-support-shared-runtimes 's/^/%%exclude /' > %_tmppath/dyn-files-clang-support
echo "Expelling likely redundant Clang shared runtimes:" && cat %_tmppath/dyn-files-clang-support

# Emit a stanza list for %%files.
# A tool can be accompanied by a man page or not.
emit_filelist() {
    awk -F'\t' '
$1 ~ "bin" { print "%llvm_bindir/" $2; print "%_bindir/" $2 "-%v_major"; }
$1 ~ "man" { print "%llvm_man1dir/" $2 ".1*"; print "%_man1dir/" $2 "-%v_major.1*"; }
'
}

# Emit executable list for %name.
emit_filelist >%_tmppath/dyn-files-%name <<EOExecutableList
bin,man	bugpoint
bin,man	diagtool
bin,man	dsymutil
bin,man	llc
bin,man	lli
bin,man	llvm-addr2line
bin,man	llvm-ar
bin,man	llvm-as
bin,man	llvm-bcanalyzer
bin	llvm-bitcode-strip
bin	llvm-cat
bin	llvm-cfi-verify
bin,man	llvm-cov
bin	llvm-c-test
bin	llvm-cvtres
bin	llvm-cxxdump
bin,man	llvm-cxxfilt
bin,man	llvm-cxxmap
bin	llvm-debuginfod-find
bin	llvm-debuginfod
bin,man	llvm-diff
bin,man	llvm-dis
bin	llvm-dlltool
bin,man	llvm-dwarfdump
bin,man	llvm-dwarfutil
bin	llvm-dwp
bin,man	llvm-exegesis
bin,man	llvm-extract
bin	llvm-gsymutil
bin	llvm-ifs
bin,man	llvm-install-name-tool
bin	llvm-jitlink
bin,man	llvm-lib
bin,man	llvm-libtool-darwin
bin,man	llvm-link
bin,man	llvm-lipo
bin	llvm-lto
bin	llvm-lto2
bin,man	llvm-mc
bin,man	llvm-mca
bin	llvm-ml
bin	llvm-modextract
bin	llvm-mt
bin,man	llvm-nm
bin,man	llvm-objcopy
bin,man	llvm-objdump
bin,man	llvm-opt-report
bin,man	llvm-otool
bin,man	llvm-pdbutil
bin,man	llvm-profdata
bin,man	llvm-profgen
bin,man	llvm-ranlib
bin	llvm-rc
bin,man	llvm-readelf
bin,man	llvm-readobj
bin,man	llvm-reduce
bin,man	llvm-remark-size-diff
bin	llvm-rtdyld
bin,man	llvm-size
bin	llvm-sim
bin	llvm-tapi-diff
bin,man	llvm-tli-checker
bin	llvm-windres
bin	llvm-split
bin,man	llvm-stress
bin,man	llvm-strings
bin,man	llvm-strip
bin,man	llvm-symbolizer
bin,man	llvm-tblgen
bin,man	llvm-debuginfo-analyzer
bin,man	llvm-remarkutil
bin	llvm-undname
bin	llvm-xray
bin	modularize
bin,man	opt
bin	pp-trace
bin	run-clang-tidy
bin	sancov
bin	sanstats
bin	verify-uselistorder

man	FileCheck
man	extraclangtools
man	lit
man	llvm-ifs
man	llvm-locstats
man	lldb-tblgen
man	tblgen
EOExecutableList

emit_filelist >%_tmppath/dyn-files-%clang_name <<EOExecutableList
bin,man	clang
bin	clang++
bin	clang-cl
bin	clang-cpp
EOExecutableList

emit_filelist >%_tmppath/dyn-files-%clang_name-analyzer <<EOExecutableList
bin	analyze-build
bin	intercept-build
bin,man	scan-build
bin	scan-build-py
bin	scan-view
EOExecutableList

emit_filelist >%_tmppath/dyn-files-%clang_name-tools <<EOExecutableList
bin	amdgpu-arch
bin	nvptx-arch
bin	c-index-test
bin	clang-apply-replacements
bin	clang-change-namespace
bin	clang-check
bin	clang-doc
bin	clang-extdef-mapping
bin	clang-format
bin	clang-include-cleaner
bin	clang-include-fixer
bin	clang-linker-wrapper
bin	clang-move
bin	clang-offload-bundler
bin	clang-offload-packager
bin	clang-pseudo
bin	clang-query
bin	clang-refactor
bin	clang-rename
bin	clang-reorder-fields
bin	clang-repl
bin	clang-scan-deps
bin,man	clang-tblgen
bin	clang-tidy
bin	find-all-symbols
bin	git-clang-format
bin	hmaptool
EOExecutableList

emit_filelist >%_tmppath/dyn-files-%mlir_name-tools <<EOExecutableList
bin	mlir-cpu-runner
bin	mlir-linalg-ods-yaml-gen
bin	mlir-lsp-server
bin	mlir-opt
bin	mlir-pdll
bin	mlir-pdll-lsp-server
bin	mlir-reduce
bin,man	mlir-tblgen
bin	mlir-translate
bin	tblgen-lsp-server
EOExecutableList

emit_filelist >%_tmppath/dyn-files-lib%polly_name-devel <<EOExecutableList
man	polly
EOExecutableList

%if_with openmp
emit_filelist >%_tmppath/dyn-files-lib%omp_name-devel <<EOExecutableList
%ifarch %libomptarget_arches
bin	llvm-omp-device-info
bin	llvm-omp-kernel-replay
%endif
man	llvmopenmp
EOExecutableList
%endif

# Comment out file validation for CMake targets placed
# in a different package.
sed -i '
/APPEND _cmake_import_check_targets \(mlir-\|MLIR\)/ {s|^|#|}
/APPEND _cmake_import_check_targets \(tblgen-lsp-server\)/ {s|^|#|}
/APPEND _cmake_import_check_targets \(Polly\)/ {s|^|#|}
/APPEND _cmake_import_check_targets \(llvm-omp-device-info\|llvm-omp-kernel-replay\|omptarget\)/ {s|^|#|}
/APPEND _cmake_import_check_targets \(omp\)/ {s|^|#|}
' %buildroot%llvm_libdir/cmake/llvm/LLVMExports-*.cmake

# Comment out file validation for CMake targets producing executables
# that may be placed in a different package.
sed -i '
/APPEND _cmake_import_check_files_for_.* .*[/]bin[/].*/ {s|^|#|}
' %buildroot%llvm_libdir/cmake/clang/ClangTargets-*.cmake

# Shared cmake files for llvm projects
mkdir -p %buildroot%llvm_datadir/cmake
cp -ar cmake/Modules %buildroot%llvm_datadir/cmake/

%if_with openmp
# XXX: libomptarget is NOT supported on LoongArch, but surpisingly some
# bits are built anyway. Remove those to avoid an rpmbuild error due to
# unpackaged files
%ifarch loongarch64
rm %buildroot%_libdir/libomptarget.so.%omp_sover
rm %buildroot%llvm_libdir/libomptarget.so.%omp_sover
rm %buildroot%llvm_libdir/libomptarget.devicertl.a
rm %buildroot%llvm_libdir/libomptarget-amdgpu-*.bc
rm %buildroot%llvm_libdir/libomptarget-nvptx-*.bc
rm %buildroot%llvm_libdir/libomptarget.so
rm %buildroot%_bindir/llvm-omp-device-info-%v_major
rm %buildroot%_bindir/llvm-omp-kernel-replay-%v_major
rm %buildroot%llvm_bindir/llvm-omp-device-info
rm %buildroot%llvm_bindir/llvm-omp-kernel-replay
%endif
%endif

%check
%if_enabled tests
LD_LIBRARY_PATH=%buildroot%llvm_libdir:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH
ninja -C %builddir check-all || :
%endif

# Do not generate dependencies for clang-{format,rename} plugins.
%add_findreq_skiplist %llvm_datadir/clang/*

%files filesystem
%dir %llvm_prefix
%dir %llvm_bindir
%dir %llvm_libdir
%dir %llvm_libdir/cmake
%dir %llvm_includedir
%dir %llvm_libexecdir
%if "%_libsuff" == "64"
%dir %llvm_prefix/lib
%endif
%dir %llvm_datadir
%dir %llvm_datadir/cmake
%dir %llvm_datadir/clang
%dir %llvm_datadir/man
%dir %llvm_man1dir
%dir %llvm_docdir
%dir %llvm_docdir/LLVM
%if_with lldb
%dir %llvm_python3_libdir
%dir %llvm_python3_sitelibdir
%endif

%files -f %_tmppath/dyn-files-%name
%doc llvm/CREDITS.TXT llvm/LICENSE.TXT llvm/README.txt

%files libs
%llvm_libdir/libLLVM-*.so
%_libdir/libLLVM-*.so
%llvm_libdir/libLTO.so.*
%_libdir/libLTO.so.*
%llvm_libdir/libRemarks.so.*
%_libdir/libRemarks.so.*

%files tools
%llvm_datadir/opt-viewer

%files devel
%llvm_bindir/llvm-config
%_bindir/llvm-config-%v_major
%llvm_man1dir/llvm-config.1.*
%_man1dir/llvm-config-%v_major.1.*
%llvm_includedir/llvm
%llvm_includedir/llvm-c
%llvm_libdir/libLLVM.so
%llvm_libdir/libLTO.so
%llvm_libdir/libRemarks.so
%llvm_libdir/LLVMHello.so
%llvm_libdir/BugpointPasses.so
%llvm_libdir/cmake/llvm
%llvm_libdir/libLLVM*.a

%files gold
%llvm_libdir/LLVMgold.so

%files -n %clang_name -f %_tmppath/dyn-files-%clang_name
%doc %builddir/clang-docs/*
%llvm_bindir/clang-%v_major
%llvm_datadir/clang/bash-autocomplete.sh
%_datadir/bash-completion/completions/clang*

%files -n libclang%clang_sover
%llvm_libdir/libclang.so.%{clang_sover}*
%_libdir/libclang.so.%{clang_sover}*

%files -n libclang-cpp%clang_cpp_sover
%llvm_libdir/libclang-cpp*.so.%{clang_cpp_sover}*
%_libdir/libclang-cpp*.so.%{clang_cpp_sover}*

%files -n %clang_name-libs
# This is a compat package.

%files -n %clang_name-support -f %_tmppath/dyn-files-clang-support
%llvm_libdir/clang
# clang-tools
%ifarch %hwasan_symbolize_arches
%exclude %llvm_libdir/clang/%v_major/bin/hwasan_symbolize
%endif
%if_with openmp
%exclude %llvm_libdir/clang/%v_major/include/omp.h
%ifnarch %arm
%exclude %llvm_libdir/clang/%v_major/include/omp-tools.h
%exclude %llvm_libdir/clang/%v_major/include/ompt.h
%exclude %llvm_libdir/clang/%v_major/include/ompt-multiplex.h
%endif
%endif #openmp

%files -n %clang_name-support-shared-runtimes -f %_tmppath/libclang-support-shared-runtimes

%files -n %clang_name-devel
%llvm_includedir/clang
%llvm_includedir/clang-c
%llvm_includedir/clang-tidy
%llvm_libdir/libclang*.so
%llvm_libdir/cmake/clang
%llvm_libdir/libclang*.a
%exclude %llvm_libdir/libclangTidy*.a
%llvm_libdir/libfindAllSymbols.a

%files -n %clang_name-tidy-devel-static
%llvm_libdir/libclangTidy*.a

%files -n %clang_name-analyzer -f %_tmppath/dyn-files-%clang_name-analyzer
%llvm_libexecdir/c++-analyzer
%llvm_libexecdir/ccc-analyzer
%llvm_datadir/scan-build
%llvm_datadir/scan-view
%llvm_prefix/lib/libear
%llvm_prefix/lib/libscanbuild
%llvm_libexecdir/analyze-*
%llvm_libexecdir/intercept-*

%files -n %clang_name-tools -f %_tmppath/dyn-files-%clang_name-tools
%llvm_datadir/clang
%exclude %llvm_datadir/clang/bash-autocomplete.sh
%ifarch %hwasan_symbolize_arches
%llvm_libdir/clang/%v_major/bin/hwasan_symbolize
%endif

%files -n %clangd_name
%llvm_bindir/clangd
%_bindir/clangd-%v_major

%if_with lld
%files -n %lld_name
%llvm_bindir/lld
%_bindir/lld-%v_major
%llvm_bindir/lld-link
%_bindir/lld-link-%v_major
%llvm_bindir/ld*.lld
%_bindir/ld*.lld-%v_major
%llvm_bindir/wasm-ld
%_bindir/wasm-ld-%v_major

%files -n %lld_name-devel
%dir %llvm_includedir/lld
%llvm_includedir/lld/*
# see Patch18: lld-compact-unwind-encoding.h.patch
%llvm_includedir/mach-o
%llvm_libdir/cmake/lld
%llvm_libdir/liblld*.a
%endif

%if_with lldb
%files -n %lldb_name
%llvm_bindir/lldb
%_bindir/lldb-%v_major
%llvm_man1dir/lldb.1*
%_man1dir/lldb-%v_major.1*
%llvm_bindir/lldb-argdumper
%_bindir/lldb-argdumper-%v_major
%llvm_bindir/lldb-instr
%_bindir/lldb-instr-%v_major
%llvm_bindir/lldb-server
%_bindir/lldb-server-%v_major
%llvm_man1dir/lldb-server.1*
%_man1dir/lldb-server-%v_major.1*
%llvm_bindir/lldb-vscode
%_bindir/lldb-vscode-%v_major

%files -n lib%lldb_name
%llvm_libdir/liblldb*.so.*
%_libdir/liblldb*.so.*

%files -n lib%lldb_name-devel
%llvm_includedir/lldb
%llvm_libdir/liblldb*.so
# %_libdir/liblldb*.so

%files -n python3-module-%lldb_name
%llvm_python3_sitelibdir/lldb
%endif

%files -n lib%mlir_name
%llvm_libdir/libMLIR.so.*
%_libdir/libMLIR.so.*
%llvm_libdir/libmlir_async_runtime.so.*
%_libdir/libmlir_async_runtime.so.*
%llvm_libdir/libmlir_c_runner_utils.so.*
%_libdir/libmlir_c_runner_utils.so.*
%llvm_libdir/libmlir_runner_utils.so.*
%llvm_libdir/libmlir_float16_utils.so.*
%_libdir/libmlir_runner_utils.so.*
%_libdir/libmlir_float16_utils.so.*

%files -n lib%mlir_name-devel
%llvm_includedir/mlir
%llvm_includedir/mlir-c
%llvm_libdir/libMLIR*.a
%llvm_libdir/libMLIR.so
%llvm_libdir/libmlir_async_runtime.so
%llvm_libdir/libmlir_c_runner_utils.so
%llvm_libdir/libmlir_runner_utils.so
%llvm_libdir/libmlir_float16_utils.so
%llvm_libdir/cmake/mlir

%files -n %mlir_name-tools -f %_tmppath/dyn-files-%mlir_name-tools

%files polly
%llvm_libdir/LLVMPolly.so

%files -n lib%polly_name-devel -f %_tmppath/dyn-files-lib%polly_name-devel
%llvm_includedir/polly
%llvm_libdir/cmake/polly
%llvm_libdir/libPolly*.a

%files doc
%doc %llvm_docdir/LLVM/llvm

%files -n %clang_name-doc
%doc %llvm_docdir/LLVM/clang
%doc %llvm_docdir/LLVM/clang-tools

%if_with lld
%files -n %lld_name-doc
%doc %llvm_docdir/lld
%endif

%if_with lldb
%files -n %lldb_name-doc
%doc %llvm_docdir/LLVM/lldb
%endif

%files -n lib%polly_name-doc
%doc %llvm_docdir/LLVM/polly

%if_with openmp
%files -n lib%omp_name
%llvm_libdir/libomp.so.%omp_vmajor
%_libdir/libomp.so.%omp_vmajor
%ifarch %libomptarget_arches
%llvm_libdir/libomptarget.rtl.amdgpu.so.%omp_sover
%llvm_libdir/libomptarget.rtl.cuda.so.%omp_sover
%llvm_libdir/libomptarget.rtl.%libomp_arch.so.%omp_sover
%llvm_libdir/libomptarget.so.%omp_sover
%_libdir/libomptarget.rtl.amdgpu.so.%omp_sover
%_libdir/libomptarget.rtl.cuda.so.%omp_sover
%_libdir/libomptarget.rtl.%libomp_arch.so.%omp_sover
%_libdir/libomptarget.so.%omp_sover
%endif

%files -n lib%omp_name-devel -f %_tmppath/dyn-files-lib%omp_name-devel
%llvm_libdir/clang/%v_major/include/omp.h
%llvm_libdir/libomp.so
%ifnarch %arm
%llvm_libdir/libompd.so
%llvm_libdir/libarcher.so
%llvm_libdir/clang/%v_major/include/omp-tools.h
%llvm_libdir/clang/%v_major/include/ompt.h
%llvm_libdir/clang/%v_major/include/ompt-multiplex.h
%endif
%llvm_libdir/cmake/openmp
%ifarch %libomptarget_arches
%llvm_libdir/libomptarget.rtl.amdgpu.so
%llvm_libdir/libomptarget.rtl.cuda.so
%llvm_libdir/libomptarget.rtl.%libomp_arch.so
%llvm_libdir/libomptarget.devicertl.a
%llvm_libdir/libomptarget-amdgpu-*.bc
%llvm_libdir/libomptarget-nvptx-*.bc
%llvm_libdir/libomptarget.so
%endif

%files -n lib%omp_name-doc
%doc %llvm_docdir/LLVM/openmp
%endif #openmp

%files cmake-common-modules
%dir %llvm_datadir/cmake/Modules
%llvm_datadir/cmake/Modules/*

%changelog
