# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

# rt-tests is taken by perl tests for RT
Name:    linux-rt-tests
Version: 2.9
Release: alt1
Summary: Programs that test various rt-linux features
License: GPL-2.0-or-later
Group:   System/Kernel and hardware
Url:     https://wiki.linuxfoundation.org/realtime/documentation/howto/tools/rt-tests
Vcs:     git://git.kernel.org/pub/scm/utils/rt-tests/rt-tests.git

Source: %name-%version.tar
BuildRequires(pre): rpm-build-python3
BuildRequires: libnuma-devel
%{?!_without_check:%{?!_disable_check:
BuildRequires: rpm-build-vm
}}

%description
rt-tests is a test suite, that contains programs (such as cyclictest,
hwlatdetect, hackbench) that test various rt-linux features.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%make_build CFLAGS="%optflags" prefix=/usr

%install
%makeinstall_std prefix=/usr

%check
vm-run --kvm=cond %buildroot%_bindir/cyclictest -m -Sp99 -t  -D60 -q

%files
%doc COPYING MAINTAINERS README.markdown src/hwlatdetect/hwlat.txt
%_bindir/*
%python3_sitelibdir_noarch/*.py
%_man8dir/*.8*

%changelog
