%define lname liblinbox0

%def_with openblas

Name: linbox
Version: 1.7.1
Release: alt1

Summary: C++ library for computation with matrices over ints and finite fields

License: LGPL-2.1+
Group: Sciences/Mathematics
Url: https://linalg.org/

Source: https://github.com/linbox-team/linbox/releases/download/v%version/linbox-%version.tar.gz

# Couldn't find package libatlas-devel on aarch64, armh and ppc64le.
%if_without openblas
ExclusiveArch: i586 x86_64
%endif

BuildRequires: autoconf >= 2.61
BuildRequires: automake >= 1.8
BuildRequires: gcc-c++
BuildRequires: libgomp-devel
BuildRequires: libgmp-devel
BuildRequires: libiml-devel
BuildRequires: libm4ri-devel
BuildRequires: libm4rie-devel
BuildRequires: libmpfr-devel
BuildRequires: libntl-devel
BuildRequires: libflint2-devel
%if_with openblas
BuildRequires: libopenblas-devel
%else
BuildRequires: libatlas-devel
%endif
BuildRequires: fflas-ffpack-devel
BuildRequires: libtinyxml2-devel
BuildRequires: opencl-headers
# create benchmark graphics
BuildRequires: gnuplot
BuildRequires: ghostscript-classic

%description
LinBox is a C++ template library for exact, high-performance linear
algebra computation with dense, sparse, and structured matrices over
the integers and over finite fields.

%package -n %lname
Summary: C++ library for computation with matrices over ints and finite fields
Group: System/Libraries

%description -n %lname
LinBox is a C++ template library for exact, high-performance linear
algebra computation with dense, sparse, and structured matrices over
the integers and over finite fields.

%package -n lib%name-devel
Summary: Development files for LinBox, a library for computation over finite fields
Group: Development/Other
Requires: opencl-headers
Requires: glibc-devel

%description -n lib%name-devel
LinBox is a C++ template library for exact, high-performance linear
algebra computation with dense, sparse, and structured matrices over
the integers and over finite fields.

This subpackage contains the include files and library links for
developing against the Givaro library.

%prep
%setup

%build
%if_with openblas
export LIBS+="-L%_libdir -lgivaro -lopenblas -lgmp"
%endif

%autoreconf
%configure --disable-static \
%ifarch %ix86
  --disable-sse --disable-sse2 \
%endif
  --disable-sse3 --disable-ssse3 --disable-sse41 --disable-sse42 \
  --disable-avx --disable-avx2 --disable-fma --disable-fma4 \
  --enable-gmp=yes \
  %if_with openblas
    --enable-openblas=yes \
    --with-blas-libs=" -lopenblas" \
  %endif
#

%make_build

%install
%makeinstall_std
rm -f "%buildroot/%_libdir"/*.la

%files -n %lname
%_libdir/liblinbox.so.0*

%files -n lib%name-devel
%_bindir/*-config
%_includedir/%name/
%_libdir/liblinbox.so
%_pkgconfigdir/*.pc
%_man1dir/*.1*
%doc COPYING*

%changelog
