
%define sover 5
%define libname libzip%sover
%define utilsname libzip-utils
%define _cmake__builddir BUILD

Name: libzip
Version: 1.11.4
Release: alt1

Group: System/Libraries
Summary: C library for reading, creating, and modifying zip archives
Url: http://www.nih.at/libzip/
License: BSD

Source: %name-%version.tar

BuildRequires: gcc-c++ cmake
BuildRequires: /usr/bin/groff
BuildRequires: libssl-devel zlib-devel bzlib-devel

%description
libzip is a C library for reading, creating, and modifying zip archives. Files
can be added from data buffers, files, or compressed data copied directly from
other zip archives. Changes made without closing the archive can be reverted.
The API is documented by man pages.

%package -n %utilsname
Group: System/Libraries
Summary: Zip-file processing utilities
Requires: %libname = %version-%release
Conflicts: libzip <= 0.9.3-alt2
%description -n %utilsname
Zip-file processing utilities

%package -n %libname
Group: System/Libraries
Summary: C library for reading, creating, and modifying zip archives
%description -n %libname
libzip is a C library for reading, creating, and modifying zip archives. Files
can be added from data buffers, files, or compressed data copied directly from
other zip archives. Changes made without closing the archive can be reverted.
The API is documented by man pages.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %libname = %version-%release
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.


%prep
%setup -q
#sed -i '/^ADD_SUBDIRECTORY(regress)$/d' CMakeLists.txt

%build
%cmake \
    -DCMAKE_INSTALL_INCLUDEDIR=include/libzip \
    -DBUILD_SHARED_LIBS=ON \
    -DENABLE_COMMONCRYPTO:BOOL=OFF \
    -DENABLE_GNUTLS:BOOL=OFF \
    -DENABLE_MBEDTLS:BOOL=OFF \
    -DENABLE_OPENSSL:BOOL=ON \
    -DENABLE_WINDOWS_CRYPTO:BOOL=OFF \
    -DENABLE_BZIP2:BOOL=ON \
    -DENABLE_LZMA:BOOL=ON \
    -DENABLE_ZSTD:BOOL=ON \
    -DBUILD_TOOLS:BOOL=ON \
    -DBUILD_REGRESS:BOOL=ON \
    -DBUILD_EXAMPLES:BOOL=OFF \
    -DBUILD_DOC:BOOL=ON
    #
%cmake_build

%install
make -C BUILD install DESTDIR=%buildroot

%files -n %utilsname
%doc AUTHORS NEWS.* THANKS
%_bindir/*
%_man1dir/*zip*

%files -n %libname
%doc AUTHORS NEWS.* THANKS
%_libdir/*.so.%sover
%_libdir/*.so.%sover.*

%files devel
%_libdir/*.so
%_libdir/pkgconfig/*.pc
%_libdir/cmake/libzip/
%_includedir/libzip/
%_includedir/zipconf.h
%_man3dir/*zip*
%_man3dir/*ZIP*

%changelog
