%global glib2_version 2.58.1
%define soversion 2
Summary: Library for querying compressed XML metadata
Name: libxmlb
Version: 0.3.24
Release: alt1
License: LGPLv2.1
Group: System/Libraries
Url: https://github.com/hughsie/libxmlb
Source0: %name-%version.tar
BuildRequires: glib2-devel >= %glib2_version
BuildRequires: gtk-doc
BuildRequires: libstemmer-devel
BuildRequires: meson
BuildRequires: liblzma-devel
BuildRequires: libzstd-devel
BuildRequires: gobject-introspection-devel

# needed for the self tests
BuildRequires: shared-mime-info

Requires: glib2 >= %glib2_version
Requires: shared-mime-info

%description
XML is slow to parse and strings inside the document cannot be memory mapped as
they do not have a trailing NUL char. The libxmlb library takes XML source, and
converts it to a structured binary representation with a deduplicated string
table -- where the strings have the NULs included.

This allows an application to mmap the binary XML file, do an XPath query and
return some strings without actually parsing the entire document. This is all
done using (almost) zero allocations and no actual copying of the binary data.

%package -n libxmlb%soversion
Summary: Library for querying compressed XML metadata
Group: System/Libraries
Requires: %name-common = %EVR
Obsoletes: libxmlb1 <= 0.1.15-alt1

%description -n libxmlb%soversion
XML is slow to parse and strings inside the document cannot be memory mapped as
they do not have a trailing NUL char. The libxmlb library takes XML source, and
converts it to a structured binary representation with a deduplicated string
table -- where the strings have the NULs included.

%package common
Summary: Common files for %name. 
Group: System/Libraries

%description common
Common files for %name.

%package tools
Summary: XMLb utility 
Group: System/Libraries

%description tools
XMLb tool allows creating, dumping and querying binary XML blobs.

%package tests
Group: System/Libraries
Summary: Tests for the %name package
Requires: libxmlb%soversion = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %name package

%package -n libxmlb-devel
Summary: Development package for %name
Group: Development/C
Requires: %name%soversion = %EVR

%description -n libxmlb-devel
Files for development with %name.

%prep
%setup

%build
%meson \
    -Dgtkdoc=true \
    -Dtests=true

%meson_build

%check
%meson_test

%install
%meson_install

%files common
%_libdir/girepository-1.0/*.typelib

%files tools
%doc README.md LICENSE
%_bindir/xb-tool
%_man1dir/*.1*

%files -n libxmlb%soversion
%_libdir/libxmlb.so.%{soversion}*

%files tests
%_libexecdir/installed-tests/%name
%_datadir/installed-tests/%name

%files devel
%dir %_datadir/gir-1.0
%_datadir/gir-1.0/*.gir
%dir %_datadir/gtk-doc
%dir %_datadir/gtk-doc/html
%_datadir/gtk-doc/html/libxmlb
%_includedir/libxmlb-2
%_libdir/libxmlb.so
%_libdir/pkgconfig/xmlb.pc

%changelog
