%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
Group: Development/Other
%add_optflags %optflags_shared
%define oldname vsqlite++
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:        libvsqlite++
Version:    0.3.13
Release:    alt2_28
Summary:    Well designed C++ sqlite 3.x wrapper library

License:    BSD
URL:        http://vsqlite.virtuosic-bytes.com
Source0:    http://evilissimo.fedorapeople.org/releases/vsqlite--/%{version}/%{oldname}-%{version}.tar.gz

BuildRequires:  gcc-c++
BuildRequires:  gcc
BuildRequires:  boost-complete
BuildRequires:  libsqlite3-devel
BuildRequires:  libtool
BuildRequires:  doxygen
BuildRequires:  graphviz libgraphviz
Source44: import.info
Provides: vsqlite++ = %{version}-%{release}

%description
VSQLite++ is a C++ wrapper for sqlite3 using the C++ standard library and boost.
VSQLite++ is designed to be easy to use and focuses on simplicity.

%package devel
Group: Development/Other
Summary:        Development files for %{oldname}
Requires:       %{name} = %{version}-%{release}
Provides: vsqlite++-devel = %{version}-%{release}

%description devel
This package contains development files for %{oldname}.

%package doc
Group: Development/Other
BuildArch:      noarch
Summary:        Development documentation for %{oldname}
Provides: vsqlite++-doc = %{version}-%{release}

%description doc
This package contains development documentation files for %{oldname}.

%prep
%setup -n %{oldname}-%{version} -q

%build
%configure
sed -i -e 's! -shared ! -Wl,--as-needed\0!g' libtool
%make_build
doxygen Doxyfile

%install
# devel & base
install -p -m 755 -d %{buildroot}%{_libdir}
# devel only
install -p -m 755 -d %{buildroot}%{_includedir}/sqlite/ext
install -m 644 include/sqlite/*.hpp %{buildroot}%{_includedir}/sqlite
install -m 644 include/sqlite/ext/*.hpp %{buildroot}%{_includedir}/sqlite/ext
# docs
install -p -m 755 -d %{buildroot}%{_docdir}

# build for all
make DESTDIR=%{buildroot} install



%files doc
%doc ChangeLog README COPYING examples/sqlite_wrapper.cpp html/*

%files devel
%doc ChangeLog README COPYING
%{_libdir}/libvsqlitepp.so
%{_includedir}/sqlite
# Don't add .la/.a to the package
%exclude %{_libdir}/libvsqlitepp.a

%files
%doc ChangeLog README COPYING
%{_libdir}/libvsqlitepp.so.*

%changelog
