%def_disable test
%def_with doc

%define oname uriparser
Name: liburiparser
Version: 0.9.8
Release: alt1

Summary: A strictly RFC 3986 compliant URI parsing library
License: BSD
Group: System/Libraries

Url: https://uriparser.github.io/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/uriparser/uriparser/archive/uriparser-%version.tar.gz
Source: %name-%version.tar

BuildRequires: cmake gcc-c++ libcpptest-devel

%if_with doc
BuildRequires: doxygen graphviz
# uses qhelpgenerator-qt5 for doc
BuildRequires: qt5-tools
%endif

%if_enabled test
BuildRequires: libgtest-devel >= 1.9.1
%endif

%description
uriparser is a strictly RFC 3986 compliant URI parsing library.
uriparser is cross-platform, fast, supports Unicode.

%package devel
Summary: Header files for uriparser
Group: Development/Other
Requires: %name = %version-%release

%description devel
Header files for uriparser.

%prep
%setup
#__subst "s|qhelpgenerator|qhelpgenerator-qt5|g" configure*

%build
%cmake_insource \
%if_without doc
	-DURIPARSER_BUILD_DOCS:BOOL=OFF \
%endif
%if_disabled test
        -DURIPARSER_BUILD_TESTS:BOOL=OFF \
%endif
        %nil
%make_build

%install
%if_with doc
touch doc/html/FIXME.map
%endif
%makeinstall_std

%files
%doc AUTHORS ChangeLog
%_bindir/uriparse
%_libdir/lib*.so.*

%files devel
%if_with doc
%_docdir/%oname/
%endif
%_libdir/lib*.so
%_includedir/%oname/
%_pkgconfigdir/*
%_libdir/cmake/*

%changelog
