# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define sover 2

Name: liburing
Version: 2.12
Release: alt1
Summary: The io_uring library
License: (GPL-2.0-only AND LGPL-2.1-or-later) OR MIT
Group: System/Libraries
Url: https://github.com/axboe/liburing
# Old Url: http://git.kernel.dk/cgit/liburing

Source: %name-%version.tar
Patch: liburing-e2k.patch

BuildRequires: gcc-c++
%{?!_without_check:%{?!_disable_check:
BuildRequires: iproute2
BuildRequires: /proc
BuildRequires: rpm-build-vm
BuildRequires: strace
}}

%description
Provides native async IO for the Linux kernel, in a fast and efficient
manner, for both buffered and O_DIRECT.

liburing provides helpers to setup and teardown io_uring instances,
and also a simplified interface for applications that don't need
(or want) to deal with the full kernel side implementation.

%package devel
Summary: Development files for Linux-native io_uring I/O access library
Group: Development/C
Requires: %name = %EVR

%description devel
This package provides header files to include and libraries to link with
for the Linux-native io_uring.

%prep
%setup
%ifarch %e2k
%patch -p1
%endif
sed -i '/MAKE.*examples/d' Makefile

%build
%add_optflags %(getconf LFS_CFLAGS) -ffat-lto-objects
./configure \
	--prefix=%_prefix \
	--includedir=%_includedir \
	--libdir=%_libdir \
	--libdevdir=%_libdir \
	--mandir=%_mandir \
	%nil
%make_build CFLAGS="%optflags" V=1

%install
%makeinstall_std V=1
rm %buildroot%_libdir/liburing*.a
# Reuse probe test as a tool to test that io_uring is available.
install -Dp test/probe.t %buildroot%_bindir/io_uring_ok

%check
# Test build examples but do not install their binaries into %%doc.
%make_build -C examples
%make_build -C examples clean
rm examples/Makefile

uname -rm
# List of available probes
test/probe.t
strace -v test/probe.t

%ifnarch %e2k
# https://github.com/axboe/liburing/issues/1207
TEST_EXCLUDE="
	conn-unreach.t
%ifarch ppc64le
	recvsend_bundle-inc.t
	recvsend_bundle.t
%endif
" vm-run --ext4 make runtests
%endif

%define _customdocdir %_docdir/%name

%files
%_bindir/io_uring_ok
%_libdir/liburing-ffi.so.%sover
%_libdir/liburing.so.%sover
%_libdir/liburing-ffi.so.%version
%_libdir/liburing.so.%version
%doc LICENSE

%files devel
%doc README COPYING COPYING.GPL SECURITY.md CHANGELOG examples
%exclude %_docdir/%name/LICENSE
%_includedir/liburing*
%_libdir/liburing.so
%_libdir/liburing-ffi.so
%_pkgconfigdir/liburing*.pc
%_man2dir/io_uring*.2*
%_man3dir/IO_URING*.3*
%_man3dir/__io_uring*.3*
%_man3dir/io_uring*.3*
%_man7dir/io_uring.7*

%changelog
