%define soname_upnp 17
%define soname_ixml 11

Name: libupnp
Version: 1.14.25
Release: alt1

Summary: Linux SDK for UPnP Devices
License: BSD
Group: System/Libraries
Url: https://github.com/pupnp/pupnp

Source: %name-%version-%release.tar

%define desc \
The Linux SDK for UPnP Devices (libupnp) provides developers with an API \
and open source code for building control points, devices, and bridges that \
are compliant with Version 1.0 of the Universal Plug and Play Device \
Architecture Specification.

%description %desc
UPnP is an architecture that enables discovery, event notification, and
control of devices on a network, independent of operating system, programming
language, or physical network connection. UPnP is based on common Internet
standards and specifications such as TCP/IP, HTTP, and XML. For detailed
information about UPnP, including the UPnP Device Architecture Specification,
please visit the UPnP Forum web site.

%package -n libixml%soname_ixml
Summary: Complementary library for Linux SDK for UPnP Devices
Group: System/Libraries

%package -n libupnp%soname_upnp
Summary: Linux SDK for UPnP Devices
Group: System/Libraries

%package devel
Summary: Development libraries and header files for libupnp
Group: Development/C

%description -n libixml%soname_ixml %desc

%description -n libupnp%soname_upnp %desc

%description devel %desc
This package contains libraries and header files needed to develop
applications using libupnp.

%prep
%setup

%build
%autoreconf
%configure --enable-ipv6 --enable-reuseaddr --disable-static
%make_build

%install
%make_install DESTDIR=%buildroot install

%files -n libixml%soname_ixml
%_libdir/libixml.so.*

%files -n libupnp%soname_upnp
%_libdir/libupnp.so.*

%files devel
%doc README.md
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%changelog
