# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: libtracefs
Version: 1.8.2
Release: alt1
Summary: Library to access kernel tracefs
License: LGPL-2.1-only
Group: System/Libraries
Url: https://git.kernel.org/pub/scm/libs/libtrace/libtracefs.git

Source: %name-%version.tar

Conflicts: trace-cmd-libs < 2.9.6-alt1
BuildRequires: asciidoc
BuildRequires: libtraceevent-devel
BuildRequires: xmlto
%{?!_without_check:%{?!_disable_check:
BuildRequires: CUnit-devel
}}

%description
%summary.

%package tools
Summary: %summary (sqlhist)
Group: Development/Tools
Requires: %name = %EVR

%description tools
%summary.

As sqlhist is just example code from a man page, it is guaranteed to contain
lots of bugs. For one thing, not all error paths are covered properly.

%package devel
Summary: %summary (Headers)
Group: Development/C
Requires: %name = %EVR

%description devel
%summary.

%package doc
Summary: %summary (Documentation)
Group: Development/Documentation

%description doc
%summary.

%prep
%setup
sed -i 's/,-rpath=\$\$ORIGIN//' scripts/utils.mk

%build
%define optflags_lto %nil
%add_optflags %(getconf LFS_CFLAGS)
export CFLAGS="%optflags"
%make_build prefix=%_prefix libdir=%_libdir all doc sqlhist V=1

%install
%makeinstall_std prefix=%_prefix libdir=%_libdir install_doc V=1
rm %buildroot%_libdir/libtracefs.a
install -Dp bin/sqlhist %buildroot%_bindir/sqlhist
install -Dpm644 samples/sqlhist.bash %buildroot%_datadir/bash-completion/completions/sqlhist.bash

%check
%make_build test V=1
utest/trace-utest

%files
%doc LICENSES/LGPL-2.1 LICENSES/GPL-2.0
%_libdir/libtracefs.so.*

%files tools
%_bindir/sqlhist
%_man1dir/sqlhist.1*
%_datadir/bash-completion/completions/sqlhist.bash
%_datadir/bash-completion/completions/tracefs_sql.bash

%files devel
%doc README
%_includedir/tracefs
%_libdir/libtracefs.so
%_pkgconfigdir/libtracefs.pc
%_man3dir/*.3*

%files doc
%_defaultdocdir/%name-doc

%changelog
