%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define soname 32

Name: libtorrent
Epoch: 3
Version: 0.16.2
Release: alt1
Summary: libTorrent is a BitTorrent library written in C++ for *nix
Group: System/Libraries
# "libtorrent/src/utils/sha_fast.{cc,h}" is originally from the
# Mozilla NSS and is under a triple license; MPL, LGPL and GPL
License: GPLv2+ AND LGPL-2.1 AND MPL-1.1
Url: https://github.com/rakshasa/libtorrent
Vcs: https://github.com/rakshasa/libtorrent.git
Source: %name-%version.tar

Patch0: %name-alt-skip-tests.patch
Patch1: %name-utils-add-missing-inc.patch

BuildRequires: gcc-c++ cppunit-devel zlib-devel libcurl-devel libssl-devel

%def_disable static

%description
libTorrent is designed to avoid redundant copying and storing of data
that other clients and libraries suffer from. libTorrent features:

* The client has full control over the polling of sockets.
* Sigc++ signals makes it easy for the client to react to events.
* Fast resume which checks the file modification time.
* Direct reading and writing from network to mmap'ed files.
* File hash check uses the same thread; client can control the rate;
  non-blocking and preload to memory with the mincore and madvise.
* File handler: fine-grained use of file read/write permissions, allows
  seeding of read-only files; allows torrents with unlimited number of
  files; opens closed files when mapping chunks to memory, with graceful
  error handling; support for files larger than 2 GB; different download
  priorities for files in the torrent.
* Multi-tracker support.
* No dependency on any specific HTTP library, the client implements a
  wrapper class.
* Dynamic request pipe size.
* Upload and download throttle.
* And much more...

%package -n %name%soname
Summary: Development libraries and header files for libTorrent
Group: System/Libraries

%description -n %name%soname
libTorrent is designed to avoid redundant copying and storing of data
that other clients and libraries suffer from. libTorrent features:

* The client has full control over the polling of sockets.
* Sigc++ signals makes it easy for the client to react to events.
* Fast resume which checks the file modification time.
* Direct reading and writing from network to mmap'ed files.
* File hash check uses the same thread; client can control the rate;
  non-blocking and preload to memory with the mincore and madvise.
* File handler: fine-grained use of file read/write permissions, allows
  seeding of read-only files; allows torrents with unlimited number of
  files; opens closed files when mapping chunks to memory, with graceful
  error handling; support for files larger than 2 GB; different download
  priorities for files in the torrent.
* Multi-tracker support.
* No dependency on any specific HTTP library, the client implements a
  wrapper class.
* Dynamic request pipe size.
* Upload and download throttle.
* And much more...

%package devel
Summary: Development libraries and header files for libTorrent
Group: Development/C
Requires: %name%soname = %EVR
Conflicts: libtorrent-rasterbar-devel

%description devel
The libtorrent-devel package contains libraries and header files needed
to develop applications using libTorrent.

%prep
%setup
%ifarch %e2k
sed -i "/private:/{N;s|private:||;s|$|private:|}" src/torrent/poll_select.h
%endif
%autopatch -p1

mv -f COPYING COPYING.orig
ln -s $(relative %_licensedir/GPL-2 %_docdir/%name/COPYING) COPYING

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std

# ix86 fails on test_extents::test_basic
%ifnarch %ix86
%check
%make_build check
%endif

%files -n %name%soname
%doc AUTHORS README.md
%doc --no-dereference COPYING
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%changelog
