Name: libtomcrypt
Version: 1.18.2
Release: alt4
Summary: A comprehensive, portable cryptographic toolkit
Group: System/Libraries
License: WTFPL
Url: http://www.libtom.net/

# https://github.com/libtom/libtomcrypt.git
Source: crypt-%version.tar.xz

Patch1: CVE-2019-17362.patch

BuildRequires: dblatex libtommath-devel

%description
A comprehensive, modular and portable cryptographic toolkit that
provides developers with a vast array of well known published block
ciphers, one-way hash functions, chaining modes, pseudo-random number
generators, public key cryptography and a plethora of other routines.

Designed from the ground up to be very simple to use. It has a modular
and standard API that allows new ciphers, hashes and PRNGs to be added
or removed without change to the overall end application. It features
easy to use functions and a complete user manual which has many source
snippet examples.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package doc
Summary: Documentation files for %name
Group: Documentation
Requires: %name = %version-%release
BuildArch: noarch

%description doc
The %name-doc package contains documentation for use with %name.

%prep
%setup
%patch1 -p1

%build
# no configure script ships with libtomcrypt.  Its only requirement is
# ANSI C. And libtommath.  Explicitly force it to be built against libtommath
export CFLAGS="%optflags -DLTM_DESC -I%_includedir/tommath"
%make_build V=1 LIBPATH=%_libdir EXTRALIBS="-ltommath" -f makefile.shared library
%make_build V=1 LIBPATH=%_libdir -f makefile docs

%check
export CFLAGS="%optflags -DLTM_DESC -DUSE_LTM -I%_includedir/tommath -I testprof"
%make_build V=1 LIBPATH=%_libdir EXTRALIBS="-L.libs -ltommath" -f makefile.shared test
LD_LIBRARY_PATH=.libs ./test

%install
# There is no configure script that ships with libtomcrypt but it does
# have understand DESTDIR and its installs via that and the
# INSTALL_USER and INSTALL_GROUP environment variables.

export INSTALL_USER=$(id -un)
export INSTALL_GROUP=$(id -gn)
export CFLAGS="%optflags -DLTM_DESC -DUSE_LTM"

%makeinstall_std INCPATH=%_includedir/tomcrypt LIBPATH=%_libdir EXTRALIBS="-ltommath" -f makefile.shared
find %buildroot -name '*.h' -exec chmod 644 {} ';'

# remove unneeded files
find %buildroot -name '*.la' -exec rm -f {} ';'
find %buildroot -name 'libtomcrypt_prof*' -exec rm -f {} ';'
find %buildroot -name '*.a' -exec rm -f {} ';'

%files
%doc LICENSE
%_libdir/*.so.*

%files devel
%doc LICENSE
%_includedir/tomcrypt
%_libdir/*.so
%_pkgconfigdir/*.pc

%files doc
%doc LICENSE doc/crypt.pdf

%changelog
