Name: libsuil
Version: 0.10.24
Release: alt1

Summary: A lightweight C library for loading and wrapping LV2 plugin UIs
License: ISC
Group: System/Libraries
Url: https://gitlab.com/lv2/suil

Source: %name-%version.tar

BuildRequires: meson
BuildRequires: pkgconfig(lv2)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(gtk+-2.0)
BuildRequires: pkgconfig(gtk+-x11-2.0)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(gtk+-x11-3.0)
BuildRequires: pkgconfig(Qt5Widgets)
BuildRequires: pkgconfig(Qt5X11Extras)
BuildRequires: pkgconfig(Qt6Widgets)

%package gtk2
Summary: suil gtk2 wrapper plugin
Group: System/Libraries
Requires: libsuil = %EVR

%package gtk3
Summary: suil gtk3 wrapper plugin
Group: System/Libraries
Requires: libsuil = %EVR

%package qt5
Summary: suil qt5 wrapper plugin
Group: System/Libraries
Requires: libsuil = %EVR

%package qt6
Summary: suil qt6 wrapper plugin
Group: System/Libraries
Requires: libsuil = %EVR

%package devel
Summary: Development libraries and headers for suil
Group: Development/C

%define desc\
suil makes it possible to load a UI of any toolkit in a host using any other\
toolkit (assuming the toolkits are both supported by suil). Hosts do not need\
to build against or link to foreign toolkit libraries to use UIs written with\
that toolkit suil performs its magic at runtime using dynamically loaded modules.

%description %desc

%description gtk2 %desc

%description gtk3 %desc

%description qt5 %desc

%description qt6 %desc

%description devel %desc
This package contains the headers and development libraries for suil.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%files
%doc AUTHORS COPYING NEWS README.md
%dir %_libdir/suil-0
%_libdir/libsuil-0.so.*
%_libdir/suil-0/libsuil_x11.so

%files gtk2
%_libdir/suil-0/libsuil_x11_in_gtk2.so

%files gtk3
%_libdir/suil-0/libsuil_x11_in_gtk3.so

%files qt5
%_libdir/suil-0/libsuil_x11_in_qt5.so

%files qt6
%_libdir/suil-0/libsuil_x11_in_qt6.so

%files devel
%_libdir/libsuil-0.so
%_libdir/pkgconfig/suil-0.pc
%_includedir/suil-0

%changelog
