%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: libslirp
Version: 4.8.0
Release: alt2
Summary: A general purpose TCP-IP emulator
Group: System/Libraries
License: BSD-3-Clause
Url: https://gitlab.freedesktop.org/slirp/libslirp
Source: %name-%version.tar

BuildRequires(pre): meson
BuildRequires: glib2-devel

%description
libslirp is a user-mode networking library used by virtual machines,
containers, and various tools.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup
echo "%version" > .tarball-version

%build
%meson
%meson_build --verbose

%install
%meson_install

%check
grep -Fx '#define SLIRP_VERSION_STRING "%version"' %buildroot%_includedir/slirp/libslirp-version.h
%meson_test

%files
%doc README.md COPYRIGHT CHANGELOG.md
%_libdir/%name.so.0*

%files devel
%_includedir/slirp
%_libdir/%name.so
%_pkgconfigdir/slirp.pc

%changelog
