%define soname 1

Name: libsixel
Version: 1.10.5
Release: alt2

Summary: A SIXEL encoder/decoder implementation
License: MIT
Group: System/Libraries
URL: https://github.com/libsixel/libsixel

Source0: %name-%version.tar
# CVE-2025-9300
# https://github.com/saitoha/libsixel/issues/200
Patch: CVE-2025-9300.patch

BuildRequires(pre): meson

# Automatically added by buildreq on Fri Nov 23 2018 (-bb)
BuildRequires: libcurl-devel libgd3-devel libgdk-pixbuf-devel libjpeg-devel libnss-myhostname libpng-devel
BuildRequires: libstb-devel >= 2.38-alt7.g40adb99.20241008

%description
This package provides encoder/decoder implementation for DEC SIXEL graphics,
and some converter programs.

%package -n %{name}%{soname}
Summary: %summary
Group: System/Libraries
Provides: %name = %EVR

%description -n %{name}%{soname}
%summary

%package -n sixel-utils
Summary: %summary
Group: Graphics

%description -n sixel-utils
%summary

%package devel
Summary: %summary
Group: Development/C

%description devel
%summary

%package -n zsh-completion-%name
Summary: Zsh completion for %name
Group: Shells
BuildArch: noarch
Requires: %{name}%{soname} = %EVR

%description -n zsh-completion-%name
Zsh completion for %name.

%package -n bash-completion-%name
Summary: Bash completion for %name
Group: Shells
BuildArch: noarch
Requires: bash-completion
Requires: %{name}%{soname} = %EVR

%description -n bash-completion-%name
Bash completion for %name.

%prep
%setup -q
%patch -p1
# Unbundle stb_image, stb_image_write:
pushd src
ln -svf %_includedir/stb/stb_image.h %_includedir/stb/stb_image_write.h ./
popd


%build
%meson \
  -Dgdk-pixbuf2=enabled \
  -Dlibcurl=enabled
%meson_build -v

%install
%meson_install

rm -fv %buildroot%_libdir/*.a ||:

%files -n sixel-utils
%_bindir/img2sixel
%_bindir/sixel2png
%_man1dir/*

%files -n %{name}%{soname}
%_libdir/%name.so.*

%files devel
%_libdir/%name.so
%_pkgconfigdir/%name.pc
%_includedir/sixel.h
%_bindir/%name-config

%files -n zsh-completion-%name
%_datadir/zsh/site-functions/*

%files -n bash-completion-%name
%_datadir/bash-completion/completions/*

%changelog
