%def_disable snapshot

%define ver_major 0.21
%define api_ver 1
%define namespace Secret

%def_disable static
%def_enable introspection
%def_enable vala
%def_enable gtk_doc
%def_enable man
%def_disable bash_completion
%def_enable check

# since 0.21.2
# ['libgcrypt', 'gnutls', 'disabled'], value: 'libgcrypt'
%define crypto libgcrypt

Name: libsecret
Version: %ver_major.7
Release: alt1

Summary: A client library for the Secret Service DBus API
Group: System/Libraries
License: LGPL-2.1
Url: https://wiki.gnome.org/Projects/Libsecret

Vcs: https://gitlab.gnome.org/GNOME/libsecret.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch: %name-0.20.0-alt-python3_shebang.patch

%define glib_ver 2.44.0
%define vala_ver 0.17.2.12
%define gcrypt_ver 1.4.5
%define gnutls_ver 3.8.2
%define tss_ver 3.0.3

BuildRequires(pre): rpm-macros-meson >= 0.50 rpm-macros-valgrind
BuildRequires: meson
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: pkgconfig(libgcrypt) >= %gcrypt_ver
#BuildRequires: pkgconfig(gnutls) >= %gnutls_ver
BuildRequires: libtpm2-tss-devel >= %tss_ver
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools >= %vala_ver}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_man:BuildRequires: xsltproc docbook-style-xsl}
%{?_enable_bash_completion:BuildRequires: pkgconfig(bash-completion)}
%{?_enable_check:
BuildRequires: /proc fuse-gvfs dbus-tools-gui python3-module-dbus-gobject
BuildRequires: python3-module-pygobject3 python3-module-mock libgjs}

%ifarch %valgrind_arches
BuildRequires: valgrind-devel
%endif

%description
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

%package devel
Summary: Development files and libraries for %name
Group: Development/C
Requires: %name = %EVR

%description devel
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

This package provides files for development with %name.

%package devel-doc
Summary: Development documentaion for %name
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

This package provides development documentations for %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the %name library.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for %name.

%prep
%setup
%patch -p1

%build
%meson \
    -Dcrypto='%crypto' \
    %{subst_enable_meson_bool introspection introspection} \
    %{subst_enable_meson_bool vala vapi} \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_feature bash_completion bash_completion} \
    %{subst_enable_meson_bool man manpage}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
dbus-run-session %__meson_test

%files -f %name.lang
%_bindir/secret-tool
%_libdir/%name-%api_ver.so.*
%{?_enable_man:%_man1dir/secret-tool.1.*}
%{?_enable_bash_completion:%_datadir/bash-completion/completions/secret-tool}
%doc README* NEWS

%files devel
%_includedir/%name-%api_ver
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%_pkgconfigdir/%name-unstable.pc
%if_enabled vala
%_vapidir/%name-%api_ver.vapi
%_vapidir/%name-%api_ver.deps
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/%name-%api_ver
%endif

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif


%changelog
