%ifarch %ix86
%set_verify_elf_method relaxed
%endif
%brp_strip_none

Name: librtpkcs11ecp
Version: 2.16.1.0
Release: alt1

Summary: Rutoken PKCS#11 Library
License: Proprietary
Group: System/Configuration/Hardware

Url: https://www.rutoken.ru/support/download/pkcs/
Source: %name-%version.tar
ExclusiveArch: i586 x86_64 armh aarch64 mipsel mips64el e2k e2kv4 e2kv5 e2kv6

BuildRequires: libpcsclite-devel

Requires: pcsc-lite-ccid

Provides: pcsc-lite-rtpkcs11ecp = %version-%release
Obsoletes: pcsc-lite-rtpkcs11ecp < %version-%release
Conflicts: pcsc-lite-rtpkcs11ecp < %version-%release

Summary(ru_RU.UTF-8): Библиотека PKCS#11 для Рутокен ЭЦП

%description
Allow users to work with Rutoken ECP through PKCS#11 standard.

%description -l ru_RU.UTF-8
Позволяет пользоваться Рутокен ЭЦП посредством стандарта PKCS#11.

%prep
%setup
%ifarch e2kv5
# preparing for 8CB rollout (rather scarce yet);
# practical binary compatibility is good
[ -d e2kv5 ] || cp -a e2kv4 e2kv5
%endif
%ifarch e2kv6
# ditto for 16C
[ -d e2kv6 ] || cp -a e2kv4 e2kv6
%endif

%install
install -pDm644 %_arch/%name.so %buildroot%_libdir/pkcs11/%name.so
ln -s pkcs11/%name.so %buildroot%_libdir/%name.so

install -pDm644 rutokenecp.module \
        %buildroot%_sysconfdir/pkcs11/modules/rutokenecp.module

%files
%doc LICENSE NOTICE.txt
%_libdir/*.so
%_libdir/pkcs11/*.so
%config(noreplace) %_sysconfdir/pkcs11/modules/rutokenecp.module

%changelog
