# vim: set ft=spec: -*- rpm-spec -*-

%define _unpackaged_files_terminate_build 1

Name: librep
Version: 0.92.7
Release: alt1

Summary: An embeddable LISP environment
License: GPL
Group: Development/Other

ExcludeArch: armh

Url: https://sawfish.fandom.com/wiki/Main_Page
Vcs: https://github.com/SawfishWM/librep

Source: %name-%version.tar
Patch: %name-%version-%release.patch

%define platform %(%_datadir/gnu-config/config.sub %_configure_platform | sed -e 's,-%_vendor,,')

Provides: %_datadir/rep/%version/lisp
Provides: %_datadir/rep/site-lisp
Provides: %_libdir/rep/%version/%platform
Provides: %_libdir/rep/%platform

# Automatically added by buildreq on Fri Dec 26 2008
BuildRequires: libffi-devel libgdbm-devel libgmp-devel libncurses-devel libreadline-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
This is a lightweight LISP environment for UNIX. It contains a LISP
interpreter, byte-code compiler and virtual machine. Applications may
use the LISP interpreter as an extension language, or it may be used for
standalone scripts.

Originally inspired by Emacs Lisp, the language dialect combines many of
the elisp features while trying to remove some of the main deficiencies,
with features from Common Lisp and Scheme.

%package devel
Summary: librep include files and link libraries
Group: Development/Other
Requires: %name = %version-%release

%description devel
Link libraries and C header files for librep development.

%prep
%setup
%patch -p1
cp -at . -- /usr/share/gnu-config/config.{guess,sub}
%ifarch %e2k
# lcc is not GNUC actually...
sed -i '/__GNUC__/s,__OPTIMIZE__,& \&\& !defined __LCC__,' src/repint.h
%endif

%build
%add_optflags -fgnu89-inline
%autoreconf
%configure \
	--disable-static \
	--with-readline \
	--with-ffi \
	--with-extra-cflags=-fstrength-reduce
# Fix platform name
sed -ie 's,^host_type=.*$,host_type=%platform,g' librep.pc
%make_build host_type=%platform

%install
%makeinstall_std host_type=%platform
mkdir -p %buildroot%_datadir/rep/site-lisp
find %buildroot%_libdir/rep -type f -name '*.la' -delete

mkdir -p %buildroot%_rpmlibdir
cat <<EOF >%buildroot%_rpmlibdir/librep-files.req.list
# librep dirlist for %_rpmlibdir/files.req
%_datadir/rep/lisp librep
%_datadir/rep/site-lisp librep
%_libdir/rep/ librep
EOF

%files
%doc ChangeLog COPYING MAINTAINERS README TODO
%_bindir/rep
%_bindir/rep-remote
%_libdir/librep.so.*
%dir %_datadir/rep
%dir %_datadir/rep/lisp
%dir %_datadir/rep/site-lisp
%_datadir/rep/lisp/*
%dir %_libdir/rep
%_libdir/rep/rep
%_libdir/rep/*.so
%_libdir/rep/emulate-gnu-tar
%_libdir/rep/doc-strings
%_rpmlibdir/librep-files.req.list
%_man1dir/rep.1*
%_man1dir/rep-remote.1*
%_infodir/librep*
%_emacslispdir/rep-debugger.el

%files devel
%doc doc/*
%_bindir/rep-xgettext
%_bindir/repdoc
%_libdir/librep.so
%_includedir/*
%_pkgconfigdir/*
%_libdir/rep/install-aliases
%_libdir/rep/libtool
%_libdir/rep/rules.mk
%_man1dir/rep-xgettext.1*
%_man1dir/repdoc.1*

%changelog
